/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.support;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import dagger.android.AndroidInjector;
import dagger.android.HasAndroidInjector;
import dagger.internal.Preconditions;

public final class AndroidSupportInjection {
    private static final String TAG = "dagger.android.support";

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasAndroidInjector hasAndroidInjector = AndroidSupportInjection.findHasAndroidInjectorForFragment(fragment);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasAndroidInjector.getClass().getCanonicalName()));
        }
        AndroidSupportInjection.inject(fragment, hasAndroidInjector);
    }

    private static HasAndroidInjector findHasAndroidInjectorForFragment(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasAndroidInjector)) continue;
            return (HasAndroidInjector)parentFragment;
        }
        FragmentActivity activity = fragment.getActivity();
        if (activity instanceof HasAndroidInjector) {
            return (HasAndroidInjector)activity;
        }
        if (activity.getApplication() instanceof HasAndroidInjector) {
            return (HasAndroidInjector)activity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    private static void inject(Object target, HasAndroidInjector hasAndroidInjector) {
        AndroidInjector androidInjector = hasAndroidInjector.androidInjector();
        Preconditions.checkNotNull((Object)androidInjector, (String)"%s.androidInjector() returned null", hasAndroidInjector.getClass());
        androidInjector.inject(target);
    }

    private AndroidSupportInjection() {
    }
}

