/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.android.processor.AutoValue_AndroidInjectorDescriptor;
import dagger.android.processor.XTypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.tools.Diagnostic;

@AutoValue
abstract class AndroidInjectorDescriptor {
    AndroidInjectorDescriptor() {
    }

    abstract ClassName injectedType();

    abstract ImmutableSet<AnnotationSpec> scopes();

    abstract ImmutableSet<ClassName> modules();

    abstract ClassName enclosingModule();

    abstract XExecutableElement method();

    static final class Validator {
        private final XMessager messager;

        Validator(XMessager messager) {
            this.messager = messager;
        }

        Optional<AndroidInjectorDescriptor> createIfValid(XMethodElement method) {
            ErrorReporter reporter = new ErrorReporter((XElement)method, this.messager);
            if (!method.isAbstract()) {
                reporter.reportError("@ContributesAndroidInjector methods must be abstract");
            }
            if (!method.getParameters().isEmpty()) {
                reporter.reportError("@ContributesAndroidInjector methods cannot have parameters");
            }
            Builder builder = new AutoValue_AndroidInjectorDescriptor.Builder().method((XExecutableElement)method);
            XTypeElement enclosingElement = XElements.asTypeElement((XElement)method.getEnclosingElement());
            if (!enclosingElement.hasAnnotation(XTypeNames.MODULE)) {
                reporter.reportError("@ContributesAndroidInjector methods must be in a @Module");
            }
            builder.enclosingModule(enclosingElement.getClassName());
            XType injectedType = method.getReturnType();
            if (injectedType.getTypeArguments().isEmpty()) {
                builder.injectedType(injectedType.getTypeElement().getClassName());
            } else {
                reporter.reportError("@ContributesAndroidInjector methods cannot return parameterized types");
            }
            XAnnotation annotation = method.getAnnotation(XTypeNames.CONTRIBUTES_ANDROID_INJECTOR);
            for (XType module : Validator.getTypeList(annotation.getAnnotationValue("modules"))) {
                if (module.getTypeElement().hasAnnotation(XTypeNames.MODULE)) {
                    builder.modulesBuilder().add((Object)((ClassName)module.getTypeName()));
                    continue;
                }
                reporter.reportError(String.format("%s is not a @Module", module), annotation);
            }
            for (XAnnotation scope : Sets.union((Set)method.getAnnotationsAnnotatedWith(XTypeNames.SCOPE), (Set)method.getAnnotationsAnnotatedWith(XTypeNames.SCOPE_JAVAX))) {
                builder.scopesBuilder().add((Object)JavaPoetExtKt.toAnnotationSpec((XAnnotation)scope));
            }
            for (XAnnotation qualifier : Sets.union((Set)method.getAnnotationsAnnotatedWith(XTypeNames.QUALIFIER), (Set)method.getAnnotationsAnnotatedWith(XTypeNames.QUALIFIER_JAVAX))) {
                reporter.reportError("@ContributesAndroidInjector methods cannot have qualifiers", qualifier);
            }
            return reporter.hasError ? Optional.empty() : Optional.of(builder.build());
        }

        private static ImmutableList<XType> getTypeList(XAnnotationValue annotationValue) {
            if (annotationValue.hasTypeListValue()) {
                return ImmutableList.copyOf((Collection)annotationValue.asTypeList());
            }
            if (annotationValue.hasTypeValue()) {
                return ImmutableList.of((Object)annotationValue.asType());
            }
            throw new IllegalArgumentException("Does not have type list");
        }

        private static class ErrorReporter {
            private final XElement subject;
            private final XMessager messager;
            private boolean hasError;

            ErrorReporter(XElement subject, XMessager messager) {
                this.subject = subject;
                this.messager = messager;
            }

            void reportError(String error) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, error, this.subject);
            }

            void reportError(String error, XAnnotation annotation) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, error, this.subject, annotation);
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder injectedType(ClassName var1);

        abstract ImmutableSet.Builder<AnnotationSpec> scopesBuilder();

        abstract ImmutableSet.Builder<ClassName> modulesBuilder();

        abstract Builder enclosingModule(ClassName var1);

        abstract Builder method(XExecutableElement var1);

        abstract AndroidInjectorDescriptor build();
    }
}

