/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.AutoValue_Nullability;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XNullability;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;
import java.util.Set;

@AutoValue
public abstract class Nullability {
    public static final Nullability NOT_NULLABLE = new AutoValue_Nullability((ImmutableSet<ClassName>)ImmutableSet.of(), (ImmutableSet<ClassName>)ImmutableSet.of(), false);

    public static Nullability of(XElement element) {
        ImmutableSet<ClassName> nonTypeUseNullableAnnotations = Nullability.getNullableAnnotations((XAnnotated)element);
        Optional<XType> type = Nullability.getType(element);
        ImmutableSet typeUseNullableAnnotations = ImmutableSet.of();
        boolean isKotlinTypeNullable = !element.getClosestMemberContainer().isFromJava() && type.isPresent() && type.get().getNullability() == XNullability.NULLABLE;
        return new AutoValue_Nullability(nonTypeUseNullableAnnotations, (ImmutableSet<ClassName>)Sets.difference((Set)typeUseNullableAnnotations, nonTypeUseNullableAnnotations).immutableCopy(), isKotlinTypeNullable);
    }

    private static ImmutableSet<ClassName> getNullableAnnotations(XAnnotated annotated) {
        return (ImmutableSet)annotated.getAllAnnotations().stream().map(XAnnotations::getClassName).filter(annotation -> annotation.simpleName().contentEquals("Nullable")).collect(DaggerStreams.toImmutableSet());
    }

    private static Optional<XType> getType(XElement element) {
        if (XElementKt.isMethod((XElement)element)) {
            return Optional.of(XElements.asMethod(element).getReturnType());
        }
        if (XElementKt.isVariableElement((XElement)element)) {
            return Optional.of(XElements.asVariable(element).getType());
        }
        return Optional.empty();
    }

    public abstract ImmutableSet<ClassName> nonTypeUseNullableAnnotations();

    public abstract ImmutableSet<ClassName> typeUseNullableAnnotations();

    public abstract boolean isKotlinTypeNullable();

    public ImmutableSet<ClassName> nullableAnnotations() {
        return ImmutableSet.builder().addAll(this.nonTypeUseNullableAnnotations()).addAll(this.typeUseNullableAnnotations()).build();
    }

    public final boolean isNullable() {
        return this.isKotlinTypeNullable() || !this.nullableAnnotations().isEmpty();
    }

    Nullability() {
    }
}

