/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.android.shaded.auto.common.MoreElements;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;

final class MoreDaggerTypes {
    public static boolean isTypeOf(TypeName typeName, TypeMirror type) {
        Preconditions.checkNotNull((Object)typeName);
        return type.accept(new IsTypeOf(typeName), null);
    }

    private MoreDaggerTypes() {
    }

    private static final class IsTypeOf
    extends SimpleTypeVisitor8<Boolean, Void> {
        private final TypeName typeName;

        IsTypeOf(TypeName typeName) {
            this.typeName = typeName;
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void ignored) {
            throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitNoType(NoType noType, Void p) {
            if (noType.getKind().equals((Object)TypeKind.VOID)) {
                return this.typeName.equals((Object)TypeName.VOID);
            }
            throw new IllegalArgumentException(noType + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitError(ErrorType errorType, Void p) {
            return false;
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    return this.typeName.equals((Object)TypeName.BOOLEAN);
                }
                case BYTE: {
                    return this.typeName.equals((Object)TypeName.BYTE);
                }
                case CHAR: {
                    return this.typeName.equals((Object)TypeName.CHAR);
                }
                case DOUBLE: {
                    return this.typeName.equals((Object)TypeName.DOUBLE);
                }
                case FLOAT: {
                    return this.typeName.equals((Object)TypeName.FLOAT);
                }
                case INT: {
                    return this.typeName.equals((Object)TypeName.INT);
                }
                case LONG: {
                    return this.typeName.equals((Object)TypeName.LONG);
                }
                case SHORT: {
                    return this.typeName.equals((Object)TypeName.SHORT);
                }
            }
            throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitArray(ArrayType array, Void p) {
            return this.typeName instanceof ArrayTypeName && MoreDaggerTypes.isTypeOf(((ArrayTypeName)this.typeName).componentType, array.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void ignored) {
            TypeElement typeElement = MoreElements.asType(type.asElement());
            return this.typeName instanceof ClassName && typeElement.getQualifiedName().contentEquals(((ClassName)this.typeName).canonicalName());
        }
    }
}

