/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import android.content.Context;
import android.util.Log;
import dagger.android.AndroidInjector;
import dagger.android.HasAndroidInjector;
import dagger.internal.Preconditions;

public final class AndroidInjection {
    private static final String TAG = "dagger.android";

    public static void inject(Activity activity) {
        Preconditions.checkNotNull((Object)activity, (String)"activity");
        Application application = activity.getApplication();
        if (!(application instanceof HasAndroidInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName()));
        }
        AndroidInjection.inject(activity, (HasAndroidInjector)application);
    }

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasAndroidInjector hasAndroidInjector = AndroidInjection.findHasAndroidInjectorForFragment(fragment);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasAndroidInjector.getClass().getCanonicalName()));
        }
        AndroidInjection.inject(fragment, hasAndroidInjector);
    }

    private static HasAndroidInjector findHasAndroidInjectorForFragment(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasAndroidInjector)) continue;
            return (HasAndroidInjector)parentFragment;
        }
        Activity activity = fragment.getActivity();
        if (activity instanceof HasAndroidInjector) {
            return (HasAndroidInjector)activity;
        }
        if (activity.getApplication() instanceof HasAndroidInjector) {
            return (HasAndroidInjector)activity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    public static void inject(Service service) {
        Preconditions.checkNotNull((Object)service, (String)"service");
        Application application = service.getApplication();
        if (!(application instanceof HasAndroidInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName()));
        }
        AndroidInjection.inject(service, (HasAndroidInjector)application);
    }

    public static void inject(BroadcastReceiver broadcastReceiver, Context context) {
        Preconditions.checkNotNull((Object)broadcastReceiver, (String)"broadcastReceiver");
        Preconditions.checkNotNull((Object)context, (String)"context");
        Application application = (Application)context.getApplicationContext();
        if (!(application instanceof HasAndroidInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName()));
        }
        AndroidInjection.inject((Object)broadcastReceiver, (HasAndroidInjector)application);
    }

    public static void inject(ContentProvider contentProvider) {
        Preconditions.checkNotNull((Object)contentProvider, (String)"contentProvider");
        Application application = (Application)contentProvider.getContext().getApplicationContext();
        if (!(application instanceof HasAndroidInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasAndroidInjector.class.getCanonicalName()));
        }
        AndroidInjection.inject(contentProvider, (HasAndroidInjector)application);
    }

    private static void inject(Object target, HasAndroidInjector hasAndroidInjector) {
        AndroidInjector<Object> androidInjector = hasAndroidInjector.androidInjector();
        Preconditions.checkNotNull(androidInjector, (String)"%s.androidInjector() returned null", hasAndroidInjector.getClass());
        androidInjector.inject(target);
    }

    private AndroidInjection() {
    }
}

