/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.util.Log;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.integration.android.AndroidKeystore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;

public final class AndroidKeystoreAesGcm
implements Aead {
    private static final String TAG = AndroidKeystoreAesGcm.class.getSimpleName();
    private static final int MAX_WAIT_TIME_MILLISECONDS_BEFORE_RETRY = 100;
    private final Aead keystoreAead;

    public AndroidKeystoreAesGcm(String keyId) throws GeneralSecurityException, IOException {
        this.keystoreAead = AndroidKeystore.getAead(keyId);
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        try {
            return this.keystoreAead.encrypt(plaintext, associatedData);
        }
        catch (GeneralSecurityException | ProviderException ex) {
            Log.w((String)TAG, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)ex);
            AndroidKeystoreAesGcm.sleepRandomAmount();
            return this.keystoreAead.encrypt(plaintext, associatedData);
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            return this.keystoreAead.decrypt(ciphertext, associatedData);
        }
        catch (BadPaddingException ex) {
            throw ex;
        }
        catch (GeneralSecurityException | ProviderException ex) {
            Log.w((String)TAG, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)ex);
            AndroidKeystoreAesGcm.sleepRandomAmount();
            return this.keystoreAead.decrypt(ciphertext, associatedData);
        }
    }

    private static void sleepRandomAmount() {
        int waitTimeMillis = (int)(Math.random() * 100.0);
        try {
            Thread.sleep(waitTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

