/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.util;

import java.util.Collection;
import net.spy.memcached.KeyUtil;

public final class StringUtils {
    private StringUtils() {
    }

    public static String join(Collection<String> keys, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(key);
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static boolean isJsonObject(String s) {
        if (s.startsWith("{") || s.startsWith("[") || s.equals("true") || s.equals("false") || s.equals("null")) {
            return true;
        }
        try {
            new Integer(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static void validateKey(String key) {
        byte[] keyBytes = KeyUtil.getKeyBytes(key);
        if (keyBytes.length > 250) {
            throw new IllegalArgumentException("Key is too long (maxlen = 250)");
        }
        if (keyBytes.length == 0) {
            throw new IllegalArgumentException("Key must contain at least one character.");
        }
        for (byte b : keyBytes) {
            if (b != 32 && b != 10 && b != 13 && b != 0) continue;
            throw new IllegalArgumentException("Key contains invalid characters:  ``" + key + "''");
        }
    }
}

