/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.protobuf;

import com.google.common.base.CaseFormat;
import com.google.common.collect.MapMaker;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Extension;
import com.google.protobuf.Message;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ProtoTypeAdapter
implements JsonSerializer<Message>,
JsonDeserializer<Message> {
    private static final Descriptors.FieldDescriptor.Type ENUM_TYPE = Descriptors.FieldDescriptor.Type.ENUM;
    private static final ConcurrentMap<String, ConcurrentMap<Class<?>, Method>> mapOfMapOfMethods = new MapMaker().makeMap();
    private final EnumSerialization enumSerialization;
    private final CaseFormat protoFormat;
    private final CaseFormat jsonFormat;
    private final Set<Extension<DescriptorProtos.FieldOptions, String>> serializedNameExtensions;
    private final Set<Extension<DescriptorProtos.EnumValueOptions, String>> serializedEnumValueExtensions;
    private final boolean shouldUseJsonNameFieldOption;

    public static Builder newBuilder() {
        return new Builder(EnumSerialization.NAME, CaseFormat.LOWER_UNDERSCORE, CaseFormat.LOWER_CAMEL);
    }

    private ProtoTypeAdapter(EnumSerialization enumSerialization, CaseFormat protoFormat, CaseFormat jsonFormat, Set<Extension<DescriptorProtos.FieldOptions, String>> serializedNameExtensions, Set<Extension<DescriptorProtos.EnumValueOptions, String>> serializedEnumValueExtensions, boolean shouldUseJsonNameFieldOption) {
        this.enumSerialization = enumSerialization;
        this.protoFormat = protoFormat;
        this.jsonFormat = jsonFormat;
        this.serializedNameExtensions = serializedNameExtensions;
        this.serializedEnumValueExtensions = serializedEnumValueExtensions;
        this.shouldUseJsonNameFieldOption = shouldUseJsonNameFieldOption;
    }

    public JsonElement serialize(Message src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject ret = new JsonObject();
        Map fields = src.getAllFields();
        for (Map.Entry fieldPair : fields.entrySet()) {
            Descriptors.FieldDescriptor desc = (Descriptors.FieldDescriptor)fieldPair.getKey();
            String name = this.getCustSerializedName(desc);
            if (desc.getType() == ENUM_TYPE) {
                if (fieldPair.getValue() instanceof Collection) {
                    JsonArray array = new JsonArray();
                    Collection enumDescs = (Collection)fieldPair.getValue();
                    for (Descriptors.EnumValueDescriptor enumDesc : enumDescs) {
                        array.add(context.serialize(this.getEnumValue(enumDesc)));
                        ret.add(name, (JsonElement)array);
                    }
                    continue;
                }
                Descriptors.EnumValueDescriptor enumDesc = (Descriptors.EnumValueDescriptor)fieldPair.getValue();
                ret.add(name, context.serialize(this.getEnumValue(enumDesc)));
                continue;
            }
            ret.add(name, context.serialize(fieldPair.getValue()));
        }
        return ret;
    }

    public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            JsonObject jsonObject = json.getAsJsonObject();
            Class protoClass = (Class)typeOfT;
            if (DynamicMessage.class.isAssignableFrom(protoClass)) {
                throw new IllegalStateException("only generated messages are supported");
            }
            Message.Builder protoBuilder = (Message.Builder)ProtoTypeAdapter.getCachedMethod(protoClass, "newBuilder", new Class[0]).invoke(null, new Object[0]);
            Message defaultInstance = (Message)ProtoTypeAdapter.getCachedMethod(protoClass, "getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
            Descriptors.Descriptor protoDescriptor = (Descriptors.Descriptor)ProtoTypeAdapter.getCachedMethod(protoClass, "getDescriptor", new Class[0]).invoke(null, new Object[0]);
            for (Descriptors.FieldDescriptor fieldDescriptor : protoDescriptor.getFields()) {
                Object fieldValue;
                String jsonFieldName = this.getCustSerializedName(fieldDescriptor);
                JsonElement jsonElement = jsonObject.get(jsonFieldName);
                if (jsonElement == null || jsonElement.isJsonNull()) continue;
                if (fieldDescriptor.getType() == ENUM_TYPE) {
                    if (jsonElement.isJsonArray()) {
                        ArrayList<Descriptors.EnumValueDescriptor> enumCollection = new ArrayList<Descriptors.EnumValueDescriptor>(jsonElement.getAsJsonArray().size());
                        for (JsonElement element : jsonElement.getAsJsonArray()) {
                            enumCollection.add(this.findValueByNameAndExtension(fieldDescriptor.getEnumType(), element));
                        }
                        fieldValue = enumCollection;
                    } else {
                        fieldValue = this.findValueByNameAndExtension(fieldDescriptor.getEnumType(), jsonElement);
                    }
                    protoBuilder.setField(fieldDescriptor, fieldValue);
                    continue;
                }
                if (fieldDescriptor.isRepeated()) {
                    String protoArrayFieldName = this.protoFormat.to(CaseFormat.LOWER_CAMEL, fieldDescriptor.getName()) + "_";
                    Field protoArrayField = protoClass.getDeclaredField(protoArrayFieldName);
                    TypeToken protoArrayFieldType = TypeToken.of((Type)protoArrayField.getGenericType());
                    Type protoArrayResolvedFieldType = protoArrayFieldType.getSupertype(List.class).getType();
                    fieldValue = context.deserialize(jsonElement, protoArrayResolvedFieldType);
                    protoBuilder.setField(fieldDescriptor, fieldValue);
                    continue;
                }
                Object field = defaultInstance.getField(fieldDescriptor);
                fieldValue = context.deserialize(jsonElement, field.getClass());
                protoBuilder.setField(fieldDescriptor, fieldValue);
            }
            return protoBuilder.build();
        }
        catch (Exception e) {
            throw new JsonParseException("Error while parsing proto", (Throwable)e);
        }
    }

    private String getCustSerializedName(Descriptors.FieldDescriptor fieldDescriptor) {
        DescriptorProtos.FieldOptions options = fieldDescriptor.getOptions();
        for (Extension<DescriptorProtos.FieldOptions, String> extension : this.serializedNameExtensions) {
            if (!options.hasExtension(extension)) continue;
            return (String)options.getExtension(extension);
        }
        if (this.shouldUseJsonNameFieldOption && fieldDescriptor.toProto().hasJsonName()) {
            return fieldDescriptor.getJsonName();
        }
        return this.protoFormat.to(this.jsonFormat, fieldDescriptor.getName());
    }

    private String getCustSerializedEnumValue(DescriptorProtos.EnumValueOptions options, String defaultValue) {
        for (Extension<DescriptorProtos.EnumValueOptions, String> extension : this.serializedEnumValueExtensions) {
            if (!options.hasExtension(extension)) continue;
            return (String)options.getExtension(extension);
        }
        return defaultValue;
    }

    private Object getEnumValue(Descriptors.EnumValueDescriptor enumDesc) {
        if (this.enumSerialization == EnumSerialization.NAME) {
            return this.getCustSerializedEnumValue(enumDesc.getOptions(), enumDesc.getName());
        }
        return enumDesc.getNumber();
    }

    private Descriptors.EnumValueDescriptor findValueByNameAndExtension(Descriptors.EnumDescriptor desc, JsonElement jsonElement) {
        if (this.enumSerialization == EnumSerialization.NAME) {
            for (Descriptors.EnumValueDescriptor enumDesc : desc.getValues()) {
                String enumValue = this.getCustSerializedEnumValue(enumDesc.getOptions(), enumDesc.getName());
                if (!enumValue.equals(jsonElement.getAsString())) continue;
                return enumDesc;
            }
            throw new IllegalArgumentException(String.format("Unrecognized enum name: %s", jsonElement.getAsString()));
        }
        Descriptors.EnumValueDescriptor fieldValue = desc.findValueByNumber(jsonElement.getAsInt());
        if (fieldValue == null) {
            throw new IllegalArgumentException(String.format("Unrecognized enum value: %d", jsonElement.getAsInt()));
        }
        return fieldValue;
    }

    private static Method getCachedMethod(Class<?> clazz, String methodName, Class<?> ... methodParamTypes) throws NoSuchMethodException {
        Method method;
        ConcurrentMap mapOfMethods = (ConcurrentMap)mapOfMapOfMethods.get(methodName);
        if (mapOfMethods == null) {
            mapOfMethods = new MapMaker().makeMap();
            ConcurrentMap previous = mapOfMapOfMethods.putIfAbsent(methodName, mapOfMethods);
            ConcurrentMap concurrentMap = mapOfMethods = previous == null ? mapOfMethods : previous;
        }
        if ((method = (Method)mapOfMethods.get(clazz)) == null) {
            method = clazz.getMethod(methodName, methodParamTypes);
            mapOfMethods.putIfAbsent(clazz, method);
        }
        return method;
    }

    public static enum EnumSerialization {
        NUMBER,
        NAME;

    }

    public static class Builder {
        private final Set<Extension<DescriptorProtos.FieldOptions, String>> serializedNameExtensions = new HashSet<Extension<DescriptorProtos.FieldOptions, String>>();
        private final Set<Extension<DescriptorProtos.EnumValueOptions, String>> serializedEnumValueExtensions = new HashSet<Extension<DescriptorProtos.EnumValueOptions, String>>();
        private EnumSerialization enumSerialization;
        private CaseFormat protoFormat;
        private CaseFormat jsonFormat;
        private boolean shouldUseJsonNameFieldOption;

        private Builder(EnumSerialization enumSerialization, CaseFormat fromFieldNameFormat, CaseFormat toFieldNameFormat) {
            this.setEnumSerialization(enumSerialization);
            this.setFieldNameSerializationFormat(fromFieldNameFormat, toFieldNameFormat);
            this.shouldUseJsonNameFieldOption = false;
        }

        @CanIgnoreReturnValue
        public Builder setEnumSerialization(EnumSerialization enumSerialization) {
            this.enumSerialization = Objects.requireNonNull(enumSerialization);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFieldNameSerializationFormat(CaseFormat fromFieldNameFormat, CaseFormat toFieldNameFormat) {
            this.protoFormat = fromFieldNameFormat;
            this.jsonFormat = toFieldNameFormat;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSerializedNameExtension(Extension<DescriptorProtos.FieldOptions, String> serializedNameExtension) {
            this.serializedNameExtensions.add(Objects.requireNonNull(serializedNameExtension));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSerializedEnumValueExtension(Extension<DescriptorProtos.EnumValueOptions, String> serializedEnumValueExtension) {
            this.serializedEnumValueExtensions.add(Objects.requireNonNull(serializedEnumValueExtension));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setShouldUseJsonNameFieldOption(boolean shouldUseJsonNameFieldOption) {
            this.shouldUseJsonNameFieldOption = shouldUseJsonNameFieldOption;
            return this;
        }

        public ProtoTypeAdapter build() {
            return new ProtoTypeAdapter(this.enumSerialization, this.protoFormat, this.jsonFormat, this.serializedNameExtensions, this.serializedEnumValueExtensions, this.shouldUseJsonNameFieldOption);
        }
    }
}

