/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.typeadapters;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class UtcDateTypeAdapter
extends TypeAdapter<Date> {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final String GMT_ID = "GMT";

    public void write(JsonWriter out, Date date) throws IOException {
        if (date == null) {
            out.nullValue();
        } else {
            String value = UtcDateTypeAdapter.format(date, true, UTC_TIME_ZONE);
            out.value(value);
        }
    }

    public Date read(JsonReader in) throws IOException {
        try {
            if (in.peek().equals((Object)JsonToken.NULL)) {
                in.nextNull();
                return null;
            }
            String date = in.nextString();
            return UtcDateTypeAdapter.parse(date, new ParsePosition(0));
        }
        catch (ParseException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    private static String format(Date date, boolean millis, TimeZone tz) {
        int offset;
        GregorianCalendar calendar = new GregorianCalendar(tz, Locale.US);
        calendar.setTime(date);
        int capacity = "yyyy-MM-ddThh:mm:ss".length();
        capacity += millis ? ".sss".length() : 0;
        StringBuilder formatted = new StringBuilder(capacity += tz.getRawOffset() == 0 ? "Z".length() : "+hh:mm".length());
        UtcDateTypeAdapter.padInt(formatted, calendar.get(1), "yyyy".length());
        formatted.append('-');
        UtcDateTypeAdapter.padInt(formatted, calendar.get(2) + 1, "MM".length());
        formatted.append('-');
        UtcDateTypeAdapter.padInt(formatted, calendar.get(5), "dd".length());
        formatted.append('T');
        UtcDateTypeAdapter.padInt(formatted, calendar.get(11), "hh".length());
        formatted.append(':');
        UtcDateTypeAdapter.padInt(formatted, calendar.get(12), "mm".length());
        formatted.append(':');
        UtcDateTypeAdapter.padInt(formatted, calendar.get(13), "ss".length());
        if (millis) {
            formatted.append('.');
            UtcDateTypeAdapter.padInt(formatted, calendar.get(14), "sss".length());
        }
        if ((offset = tz.getOffset(calendar.getTimeInMillis())) != 0) {
            int hours = Math.abs(offset / 60000 / 60);
            int minutes = Math.abs(offset / 60000 % 60);
            formatted.append(offset < 0 ? (char)'-' : '+');
            UtcDateTypeAdapter.padInt(formatted, hours, "hh".length());
            formatted.append(':');
            UtcDateTypeAdapter.padInt(formatted, minutes, "mm".length());
        } else {
            formatted.append('Z');
        }
        return formatted.toString();
    }

    private static void padInt(StringBuilder buffer, int value, int length) {
        String strValue = Integer.toString(value);
        for (int i = length - strValue.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }

    private static Date parse(String date, ParsePosition pos) throws ParseException {
        RuntimeException fail = null;
        try {
            String timezoneId;
            int offset = pos.getIndex();
            int year = UtcDateTypeAdapter.parseInt(date, offset, offset += 4);
            if (UtcDateTypeAdapter.checkOffset(date, offset, '-')) {
                // empty if block
            }
            int month = UtcDateTypeAdapter.parseInt(date, ++offset, offset += 2);
            if (UtcDateTypeAdapter.checkOffset(date, offset, '-')) {
                // empty if block
            }
            int day = UtcDateTypeAdapter.parseInt(date, ++offset, offset += 2);
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int milliseconds = 0;
            if (UtcDateTypeAdapter.checkOffset(date, offset, 'T')) {
                char c;
                hour = UtcDateTypeAdapter.parseInt(date, ++offset, offset += 2);
                if (UtcDateTypeAdapter.checkOffset(date, offset, ':')) {
                    // empty if block
                }
                minutes = UtcDateTypeAdapter.parseInt(date, ++offset, offset += 2);
                if (UtcDateTypeAdapter.checkOffset(date, offset, ':')) {
                    ++offset;
                }
                if (date.length() > offset && (c = date.charAt(offset)) != 'Z' && c != '+' && c != '-') {
                    seconds = UtcDateTypeAdapter.parseInt(date, offset, offset += 2);
                    if (UtcDateTypeAdapter.checkOffset(date, offset, '.')) {
                        milliseconds = UtcDateTypeAdapter.parseInt(date, ++offset, offset += 3);
                    }
                }
            }
            if (date.length() <= offset) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            char timezoneIndicator = date.charAt(offset);
            if (timezoneIndicator == '+' || timezoneIndicator == '-') {
                String timezoneOffset = date.substring(offset);
                timezoneId = GMT_ID + timezoneOffset;
                offset += timezoneOffset.length();
            } else if (timezoneIndicator == 'Z') {
                timezoneId = GMT_ID;
                ++offset;
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator " + timezoneIndicator);
            }
            TimeZone timezone = TimeZone.getTimeZone(timezoneId);
            if (!timezone.getID().equals(timezoneId)) {
                throw new IndexOutOfBoundsException();
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            pos.setIndex(offset);
            return calendar.getTime();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            fail = e;
            String input = date == null ? null : "'" + date + "'";
            throw new ParseException("Failed to parse date [" + input + "]: " + fail.getMessage(), pos.getIndex());
        }
    }

    private static boolean checkOffset(String value, int offset, char expected) {
        return offset < value.length() && value.charAt(offset) == expected;
    }

    private static int parseInt(String value, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int i = beginIndex;
        int result = 0;
        if (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value);
            }
            result = -digit;
        }
        while (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value);
            }
            result *= 10;
            result -= digit;
        }
        return -result;
    }
}

