/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringCache {
    private static final int MAX_CACHE_ENTRIES = 10000;
    private static HashMap cache;
    private static HashSet all;
    private static int considered;
    private static int hits;
    private static int skipped;
    private static int created;
    private static int couldHaveHit;
    static final boolean BCEL_STATISTICS;
    public static final boolean BCEL_DONT_CACHE;

    public static synchronized String cache(String s) {
        String result;
        if (BCEL_DONT_CACHE || s.length() > 200) {
            ++skipped;
            return s;
        }
        ++considered;
        if (cache == null) {
            int capacity = 13333;
            if (BCEL_STATISTICS) {
                all = new HashSet();
            }
            cache = new LinkedHashMap(capacity, 0.75f, true){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 10000;
                }
            };
        }
        if ((result = (String)cache.get(s)) != null) {
            ++hits;
            return result;
        }
        cache.put(s, s);
        if (BCEL_STATISTICS && !all.add(s)) {
            ++couldHaveHit;
        }
        return s;
    }

    static {
        considered = 0;
        hits = 0;
        skipped = 0;
        created = 0;
        couldHaveHit = 0;
        BCEL_STATISTICS = Boolean.getBoolean("bcel.statistics");
        BCEL_DONT_CACHE = Boolean.getBoolean("bcel.dontCache");
        if (BCEL_STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    System.err.println("Cache hit " + hits + "/" + considered + ", " + skipped + " skipped, cache size: " + cache.size() + "/" + 10000);
                    System.out.println(all.size() + " unique strings");
                    System.out.println(couldHaveHit + " potential cache hits");
                }
            });
        }
    }
}

