/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.ExtensibleClient;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.JsonHelper;
import com.google.code.facebookapi.SpecificReturnTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacebookJsonRestClientBase
extends SpecificReturnTypeAdapter<Object> {
    protected static Log log = LogFactory.getLog(FacebookJsonRestClientBase.class);

    public FacebookJsonRestClientBase(ExtensibleClient client) {
        super("json", client);
    }

    public FacebookJsonRestClientBase(String apiKey, String secret) {
        this(new ExtensibleClient("json", apiKey, secret));
    }

    public FacebookJsonRestClientBase(String apiKey, String secret, String sessionKey) {
        this(new ExtensibleClient("json", apiKey, secret, sessionKey));
    }

    public Object parseCallResult(Object rawResponse) throws FacebookException {
        return JsonHelper.parseCallResult(rawResponse);
    }

    @Override
    public List<? extends Object> executeBatch(boolean serial) throws FacebookException {
        List<String> clientResults = this.client.executeBatch(serial);
        ArrayList<Object> result = new ArrayList<Object>();
        for (String clientResult : clientResults) {
            JSONArray doc;
            try {
                doc = new JSONArray(clientResult);
            }
            catch (JSONException ex) {
                throw new RuntimeException("Error parsing client result", ex);
            }
            for (int count = 0; count < doc.length(); ++count) {
                try {
                    String response = (String)doc.get(count);
                    Object responseObject = JsonHelper.parseCallResult(response);
                    result.add(responseObject);
                    continue;
                }
                catch (Exception ignored) {
                    result.add(null);
                }
            }
        }
        return result;
    }
}

