/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.Attachment;
import com.google.code.facebookapi.BundleActionLink;
import com.google.code.facebookapi.ExtensibleClient;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookJsonRestClientBase;
import com.google.code.facebookapi.Metric;
import com.google.code.facebookapi.PageProfileField;
import com.google.code.facebookapi.PhotoTag;
import com.google.code.facebookapi.ProfileField;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookJsonRestClient
extends FacebookJsonRestClientBase {
    public FacebookJsonRestClient(ExtensibleClient client) {
        super(client);
    }

    public FacebookJsonRestClient(String apiKey, String secret) {
        super(apiKey, secret);
    }

    public FacebookJsonRestClient(String apiKey, String secret, String sessionKey) {
        super(apiKey, secret, sessionKey);
    }

    @Override
    public JSONObject pages_getInfo(Collection<Long> pageIds, Set<CharSequence> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.pages_getInfo(pageIds, fields);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_get(Collection<Long> photoIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_get(photoIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public String stream_publish(String message, Attachment attachment, List<BundleActionLink> actionLinks, Long targetId, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_publish(message, attachment, actionLinks, targetId, userId);
        return (String)this.parseCallResult(rawResponse);
    }

    @Override
    public Object photos_createAlbum(String name, String description, String location, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_createAlbum(name, description, location, userId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object profile_getFBML(int type) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.profile_getFBML(type);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public Object photos_addTags(Long photoId, Collection<PhotoTag> tags, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_addTags(photoId, tags, userId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public JSONObject notifications_get() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.notifications_get();
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject application_getPublicInfoById(Long applicationId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.application_getPublicInfoById(applicationId);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray users_getStandardInfo(Collection<Long> userIds, Set<CharSequence> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.users_getStandardInfo(userIds, fields);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object marketplace_getListings(Collection<Long> listingIds, Collection<Long> userIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.marketplace_getListings(listingIds, userIds);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray friends_get() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.friends_get();
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object profile_getInfoOptions(String field) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.profile_getInfoOptions(field);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray permissions_checkAvailableApiAccess(String apiKey) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.permissions_checkAvailableApiAccess(apiKey);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_get(Long subjId, Long albumId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_get(subjId, albumId);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray connect_unregisterUsers(Collection<String> email_hashes) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.connect_unregisterUsers(email_hashes);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray friends_getLists() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.friends_getLists();
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray friends_get(Long uid) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.friends_get(uid);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_getByAlbum(Long albumId, Collection<Long> photoIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_getByAlbum(albumId, photoIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object photos_createAlbum(String albumName) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_createAlbum(albumName);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_get(Long subjId, Collection<Long> photoIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_get(subjId, photoIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Boolean stream_addLike(String postId, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_addLike(postId, userId);
        return (Boolean)this.parseCallResult(rawResponse);
    }

    @Override
    public Object stream_getComments(String postId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_getComments(postId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject pages_getInfo(Long userId, Set<CharSequence> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.pages_getInfo(userId, fields);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public Boolean stream_removeComment(String commentId, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_removeComment(commentId, userId);
        return (Boolean)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray users_getStandardInfo(Collection<Long> userIds, Collection<ProfileField> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.users_getStandardInfo(userIds, fields);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object marketplace_search(CharSequence category, CharSequence subCategory, CharSequence query) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.marketplace_search(category, subCategory, query);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject application_getPublicInfoByCanvasName(String applicationCanvas) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.application_getPublicInfoByCanvasName(applicationCanvas);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject application_getPublicInfoByApiKey(String applicationKey) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.application_getPublicInfoByApiKey(applicationKey);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object profile_getFBML() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.profile_getFBML();
        return this.parseCallResult(rawResponse);
    }

    @Override
    public Object batch_run(String methods, boolean serial) throws FacebookException {
        this.client.setResponseFormat("json");
        String rawResponse = this.client.batch_run(methods, serial);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray data_getCookies(Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getCookies(userId);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray users_getInfo(Iterable<Long> userIds, Collection<ProfileField> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.users_getInfo(userIds, fields);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray getCacheFriendsList() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.getCacheFriendsList();
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object friends_areFriends(long userId1, long userId2) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.friends_areFriends(userId1, userId2);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(File photo, String caption, Long albumId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(photo, caption, albumId);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_getAlbums(Long userId, Collection<Long> albumIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_getAlbums(userId, albumIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object stream_get(Long viewerId, List<Long> sourceIds, Date start, Date end, Integer limit, String filterKey, List<String> metadata) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_get(viewerId, sourceIds, start, end, limit, filterKey, metadata);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject application_getPublicInfo(Long applicationId, String applicationKey, String applicationCanvas) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.application_getPublicInfo(applicationId, applicationKey, applicationCanvas);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject data_getObjectType(String objectType) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getObjectType(objectType);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(Long userId, String caption, Long albumId, String fileName, InputStream fileStream) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(userId, caption, albumId, fileName, fileStream);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject data_getAssociationDefinition(String associationName) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getAssociationDefinition(associationName);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_get(Long subjId, Long albumId, Collection<Long> photoIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_get(subjId, albumId, photoIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object photos_createAlbum(String name, String description, String location) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_createAlbum(name, description, location);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public Boolean stream_removeLike(String postId, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_removeLike(postId, userId);
        return (Boolean)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_get(Long subjId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_get(subjId);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(File photo) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(photo);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject pages_getInfo(Collection<Long> pageIds, Collection<PageProfileField> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.pages_getInfo(pageIds, fields);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(File photo, Long albumId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(photo, albumId);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray data_getCookies(Long userId, CharSequence name) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getCookies(userId, name);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_addTags(Long photoId, Collection<PhotoTag> tags) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_addTags(photoId, tags);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Boolean stream_remove(String postId, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_remove(postId, userId);
        return (Boolean)this.parseCallResult(rawResponse);
    }

    @Override
    public String data_getObjectProperty(long objectId, String propertyName) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getObjectProperty(objectId, propertyName);
        return (String)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject data_getObject(long objectId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getObject(objectId);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray users_getInfo(Iterable<Long> userIds, Set<CharSequence> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.users_getInfo(userIds, fields);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray data_getObjects(Collection<Long> objectIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getObjects(objectIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object feed_getRegisteredTemplateBundles() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.feed_getRegisteredTemplateBundles();
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_getAlbums(Collection<Long> albumIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_getAlbums(albumIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object photos_createAlbum(String albumName, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_createAlbum(albumName, userId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(File photo, String caption) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(photo, caption);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(Long userId, File photo, String caption) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(userId, photo, caption);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object profile_getFBML(Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.profile_getFBML(userId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray friends_getList(Long friendListId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.friends_getList(friendListId);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_getTags(Collection<Long> photoIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_getTags(photoIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object marketplace_getSubCategories(CharSequence category) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.marketplace_getSubCategories(category);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public Object data_getUserPreferences() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getUserPreferences();
        return this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object profile_getInfo(Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.profile_getInfo(userId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object admin_getDailyMetrics(Set<Metric> metrics, long start, long end) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.admin_getDailyMetrics(metrics, start, end);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public Object stream_getFilters(Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_getFilters(userId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray data_getObjectTypes() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getObjectTypes();
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object friends_areFriends(Collection<Long> userIds1, Collection<Long> userIds2) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.friends_areFriends(userIds1, userIds2);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public Object fbml_getCustomTags(String appId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.fbml_getCustomTags(appId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray friends_getAppUsers() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.friends_getAppUsers();
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object profile_getFBML(int type, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.profile_getFBML(type, userId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray groups_get(Long userId, Collection<Long> groupIds) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.groups_get(userId, groupIds);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime, String rsvp_status) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.events_get(userId, eventIds, startTime, endTime, rsvp_status);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray admin_getMetrics(Set<Metric> metrics, Date start, Date end, long period) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.admin_getMetrics(metrics, start, end, period);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object fql_query(CharSequence query) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.fql_query(query);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject pages_getInfo(Long userId, Collection<PageProfileField> fields) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.pages_getInfo(userId, fields);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object admin_getDailyMetrics(Set<Metric> metrics, Date start, Date end) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.admin_getDailyMetrics(metrics, start, end);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public Object events_getMembers(Long eventId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.events_getMembers(eventId);
        return this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object feed_getRegisteredTemplateBundleByID(Long id) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.feed_getRegisteredTemplateBundleByID(id);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray data_getCookies() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getCookies();
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray groups_getMembers(Number groupId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.groups_getMembers(groupId);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(Long userId, File photo, Long albumId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(userId, photo, albumId);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(Long userId, File photo, String caption, Long albumId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(userId, photo, caption, albumId);
        return (JSONObject)this.parseCallResult(rawResponse);
    }

    @Override
    @Deprecated
    public Object marketplace_getCategoriesObject() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.marketplace_getCategoriesObject();
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_getByAlbum(Long albumId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_getByAlbum(albumId);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public Object events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.events_get(userId, eventIds, startTime, endTime);
        return this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray connect_registerUsers(Collection<Map<String, String>> accounts) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.connect_registerUsers(accounts);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray admin_getMetrics(Set<Metric> metrics, long start, long end, long period) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.admin_getMetrics(metrics, start, end, period);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray permissions_checkGrantedApiAccess(String apiKey) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.permissions_checkGrantedApiAccess(apiKey);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray data_getAssociationDefinitions() throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getAssociationDefinitions();
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray photos_getAlbums(Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_getAlbums(userId);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public String stream_addComment(String postId, String comment, Long userId) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.stream_addComment(postId, comment, userId);
        return (String)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONArray data_getCookies(String name) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.data_getCookies(name);
        return (JSONArray)this.parseCallResult(rawResponse);
    }

    @Override
    public JSONObject photos_upload(Long userId, File photo) throws FacebookException {
        this.client.setResponseFormat("json");
        Object rawResponse = this.client.photos_upload(userId, photo);
        return (JSONObject)this.parseCallResult(rawResponse);
    }
}

