/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.watcher.TableId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@InternalApi(value="Public visibility for re-use by other spanner-change-watcher libraries. API-breaking changes without prior notice is possible.")
public class SpannerUtils {
    @VisibleForTesting
    public static final String FIND_COMMIT_TIMESTAMP_COLUMN_QUERY = "SELECT COLUMN_NAME, OPTION_NAME, OPTION_VALUE\nFROM INFORMATION_SCHEMA.COLUMN_OPTIONS\nWHERE TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME = @table";
    @VisibleForTesting
    static final String PK_QUERY = "SELECT COLUMN_NAME\nFROM INFORMATION_SCHEMA.INDEX_COLUMNS\nINNER JOIN INFORMATION_SCHEMA.INDEXES ON\n      INDEX_COLUMNS.TABLE_CATALOG=INDEXES.TABLE_CATALOG AND INDEX_COLUMNS.TABLE_SCHEMA=INDEX_COLUMNS.TABLE_SCHEMA AND INDEX_COLUMNS.TABLE_NAME=INDEXES.TABLE_NAME\n  AND INDEX_COLUMNS.INDEX_NAME=INDEXES.INDEX_NAME AND INDEXES.INDEX_TYPE='PRIMARY_KEY'\nWHERE INDEX_COLUMNS.TABLE_CATALOG = @catalog\nAND INDEX_COLUMNS.TABLE_SCHEMA = @schema\nAND INDEX_COLUMNS.TABLE_NAME = @table\nORDER BY INDEX_COLUMNS.ORDINAL_POSITION";

    @InternalApi
    public static ApiFuture<String> getTimestampColumn(DatabaseClient client, final TableId table) {
        final SettableApiFuture res = SettableApiFuture.create();
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)FIND_COMMIT_TIMESTAMP_COLUMN_QUERY).bind("catalog").to(table.getCatalog())).bind("schema").to(table.getSchema())).bind("table").to(table.getTable())).build(), new Options.QueryOption[0]);){
            rs.setCallback(MoreExecutors.directExecutor(), new AsyncResultSet.ReadyCallback(){

                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet rs) {
                    try {
                        switch (rs.tryNext()) {
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            case OK: {
                                if (!rs.getString("OPTION_NAME").equals("allow_commit_timestamp") || !rs.getString("OPTION_VALUE").equals("TRUE")) break;
                                res.set((Object)rs.getString("COLUMN_NAME"));
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                        }
                    }
                    catch (Throwable t) {
                        res.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                    res.setException((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Table %s does not contain a column with option allow_commit_timestamp=true", table)));
                    return AsyncResultSet.CallbackResponse.DONE;
                }
            });
        }
        return res;
    }

    @InternalApi
    public static ApiFuture<List<String>> getPrimaryKeyColumns(DatabaseClient client, TableId table) {
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)PK_QUERY).bind("catalog").to(table.getCatalog())).bind("schema").to(table.getSchema())).bind("table").to(table.getTable())).build(), new Options.QueryOption[0]);){
            ApiFuture apiFuture = rs.toListAsync((Function)new Function<StructReader, String>(){

                public String apply(StructReader input) {
                    return input.getString(0);
                }
            }, MoreExecutors.directExecutor());
            return apiFuture;
        }
    }

    @InternalApi
    public static Key buildKey(Iterable<String> pkColumns, ResultSet rs) {
        Key.Builder kb = Key.newBuilder();
        block12: for (String pkCol : pkColumns) {
            switch (rs.getColumnType(pkCol).getCode()) {
                case BOOL: {
                    kb.append(Boolean.valueOf(rs.getBoolean(pkCol)));
                    continue block12;
                }
                case BYTES: {
                    kb.append(rs.getBytes(pkCol));
                    continue block12;
                }
                case DATE: {
                    kb.append(rs.getDate(pkCol));
                    continue block12;
                }
                case FLOAT64: {
                    kb.append(rs.getDouble(pkCol));
                    continue block12;
                }
                case INT64: {
                    kb.append(rs.getLong(pkCol));
                    continue block12;
                }
                case JSON: {
                    kb.append(rs.getJson(pkCol));
                }
                case NUMERIC: {
                    kb.append(rs.getBigDecimal(pkCol));
                    continue block12;
                }
                case STRING: {
                    kb.append(rs.getString(pkCol));
                    continue block12;
                }
                case TIMESTAMP: {
                    kb.append(rs.getTimestamp(pkCol));
                    continue block12;
                }
                case STRUCT: 
                case ARRAY: {
                    throw new IllegalArgumentException("Invalid type for primary key: " + rs.getColumnType(pkCol));
                }
            }
            throw new IllegalArgumentException("Unknown type: " + rs.getColumnType(pkCol));
        }
        return kb.build();
    }

    public static class LogRecordBuilder {
        public static LogRecord of(Level level, String msg, Throwable thrown) {
            LogRecord res = new LogRecord(level, msg);
            res.setThrown(thrown);
            return res;
        }

        public static LogRecord of(Level level, String msg, Object param, Throwable thrown) {
            LogRecord res = new LogRecord(level, msg);
            res.setThrown(thrown);
            res.setParameters(new Object[]{param});
            return res;
        }

        public static LogRecord of(Level level, String msg, Object param1, Object param2) {
            LogRecord res = new LogRecord(level, msg);
            res.setParameters(new Object[]{param1, param2});
            return res;
        }
    }
}

