/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.watcher.CommitTimestampRepository;
import com.google.cloud.spanner.watcher.SpannerUtils;
import com.google.cloud.spanner.watcher.TableId;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SpannerCommitTimestampRepository
implements CommitTimestampRepository {
    private static final Logger logger = Logger.getLogger(SpannerCommitTimestampRepository.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF8");
    static final String DEFAULT_TABLE_CATALOG = "";
    static final String DEFAULT_TABLE_SCHEMA = "";
    static final String DEFAULT_TABLE_NAME = "LAST_SEEN_COMMIT_TIMESTAMPS";
    static final String DEFAULT_DATABASE_NAME_COLUMN_NAME = "DATABASE_NAME";
    static final String DEFAULT_TABLE_CATALOG_COLUMN_NAME = "TABLE_CATALOG";
    static final String DEFAULT_TABLE_SCHEMA_COLUMN_NAME = "TABLE_SCHEMA";
    static final String DEFAULT_TABLE_NAME_COLUMN_NAME = "TABLE_NAME";
    static final String DEFAULT_SHARD_ID_BOOL_COLUMN_NAME = "SHARD_ID_BOOL";
    static final String DEFAULT_SHARD_ID_BYTES_COLUMN_NAME = "SHARD_ID_BYTES";
    static final String DEFAULT_SHARD_ID_DATE_COLUMN_NAME = "SHARD_ID_DATE";
    static final String DEFAULT_SHARD_ID_FLOAT64_COLUMN_NAME = "SHARD_ID_FLOAT64";
    static final String DEFAULT_SHARD_ID_INT64_COLUMN_NAME = "SHARD_ID_INT64";
    static final String DEFAULT_SHARD_ID_STRING_COLUMN_NAME = "SHARD_ID_STRING";
    static final String DEFAULT_SHARD_ID_TIMESTAMP_COLUMN_NAME = "SHARD_ID_TIMESTAMP";
    static final String DEFAULT_COMMIT_TIMESTAMP_COLUMN_NAME = "LAST_SEEN_COMMIT_TIMESTAMP";
    static final String FIND_TABLE_STATEMENT = "SELECT TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_CATALOG=@catalog\nAND TABLE_SCHEMA=@schema\nAND TABLE_NAME=@table";
    static final String FIND_COLUMNS_STATEMENT = "SELECT COLUMN_NAME, SPANNER_TYPE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_CATALOG=@catalog\nAND TABLE_SCHEMA=@schema\nAND TABLE_NAME=@table\nORDER BY ORDINAL_POSITION";
    static final String FIND_PK_COLUMNS_STATEMENT = "SELECT INDEX_COLUMNS.COLUMN_NAME\nFROM INFORMATION_SCHEMA.INDEXES\nINNER JOIN INFORMATION_SCHEMA.INDEX_COLUMNS \n            ON  INDEXES.TABLE_CATALOG=INDEX_COLUMNS.TABLE_CATALOG\n            AND INDEXES.TABLE_SCHEMA=INDEX_COLUMNS.TABLE_SCHEMA\n            AND INDEXES.TABLE_NAME=INDEX_COLUMNS.TABLE_NAME\n            AND INDEXES.INDEX_NAME=INDEX_COLUMNS.INDEX_NAME\nWHERE INDEXES.TABLE_CATALOG=@catalog\nAND INDEXES.TABLE_SCHEMA=@schema\nAND INDEXES.TABLE_NAME=@table\nAND INDEXES.INDEX_TYPE='PRIMARY_KEY'\nORDER BY INDEX_COLUMNS.ORDINAL_POSITION";
    static final String CREATE_TABLE_STATEMENT = "CREATE TABLE `%s` (\n        `%s` STRING(MAX) NOT NULL,\n        `%s` STRING(MAX) NOT NULL,\n        `%s` STRING(MAX) NOT NULL,\n        `%s` STRING(MAX) NOT NULL,\n        `%s` BOOL,\n        `%s` BYTES(MAX),\n        `%s` DATE,\n        `%s` FLOAT64,\n        `%s` INT64,\n        `%s` STRING(MAX),\n        `%s` TIMESTAMP,\n        `%s` TIMESTAMP NOT NULL\n) PRIMARY KEY (`%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`)";
    private static final Set<String> RUNNING_CREATE_TABLE_STATEMENTS = new HashSet<String>();
    private final DatabaseId databaseId;
    private final DatabaseClient client;
    private final DatabaseAdminClient adminClient;
    private final boolean createTableIfNotExists;
    private final String commitTimestampsCatalog;
    private final String commitTimestampsSchema;
    private final String commitTimestampsTable;
    private final String databaseCol;
    private final String catalogCol;
    private final String schemaCol;
    private final String tableCol;
    private final String shardIdBoolCol;
    private final String shardIdBytesCol;
    private final String shardIdDateCol;
    private final String shardIdFloat64Col;
    private final String shardIdInt64Col;
    private final String shardIdStringCol;
    private final String shardIdTimestampCol;
    private final String tsCol;
    private final Iterable<String> tsColumns;
    private boolean initialized = false;
    private Timestamp initialCommitTimestamp;

    public static Builder newBuilder(Spanner spanner, DatabaseId databaseId) {
        return new Builder(spanner, databaseId);
    }

    private SpannerCommitTimestampRepository(Builder builder) {
        this.databaseId = builder.databaseId;
        this.client = builder.spanner.getDatabaseClient(builder.databaseId);
        this.adminClient = builder.spanner.getDatabaseAdminClient();
        this.createTableIfNotExists = builder.createTableIfNotExists;
        this.commitTimestampsCatalog = builder.commitTimestampsCatalog;
        this.commitTimestampsSchema = builder.commitTimestampsSchema;
        this.commitTimestampsTable = builder.commitTimestampsTable;
        this.databaseCol = builder.databaseCol;
        this.catalogCol = builder.catalogCol;
        this.schemaCol = builder.schemaCol;
        this.tableCol = builder.tableCol;
        this.shardIdBoolCol = builder.shardIdBoolCol;
        this.shardIdBytesCol = builder.shardIdBytesCol;
        this.shardIdDateCol = builder.shardIdDateCol;
        this.shardIdFloat64Col = builder.shardIdFloat64Col;
        this.shardIdInt64Col = builder.shardIdInt64Col;
        this.shardIdStringCol = builder.shardIdStringCol;
        this.shardIdTimestampCol = builder.shardIdTimestampCol;
        this.tsCol = builder.tsCol;
        this.initialCommitTimestamp = builder.initialCommitTimestamp;
        this.tsColumns = Collections.singleton(builder.tsCol);
    }

    private void initialize() {
        if (this.initialCommitTimestamp == null) {
            try (ResultSet rs = this.client.singleUse().executeQuery(Statement.of((String)"SELECT CURRENT_TIMESTAMP"), new Options.QueryOption[0]);){
                while (rs.next()) {
                    this.initialCommitTimestamp = rs.getTimestamp(0);
                }
            }
        }
        Statement statement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)FIND_TABLE_STATEMENT).bind("catalog").to(this.commitTimestampsCatalog)).bind("schema").to(this.commitTimestampsSchema)).bind("table").to(this.commitTimestampsTable)).build();
        try (ResultSet rs = this.client.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            if (!rs.next()) {
                if (this.createTableIfNotExists) {
                    this.createTable();
                    this.initialized = true;
                    return;
                }
                logger.log(Level.WARNING, "Commit timestamps table {0} not found", TableId.of(this.databaseId, this.commitTimestampsTable));
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Table %s not found", this.commitTimestampsTable));
            }
        }
        try {
            this.verifyTable();
        }
        catch (Throwable t) {
            logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Verification of commit timestamps table {0} failed", (Object)TableId.of(this.databaseId, this.commitTimestampsTable), t));
            throw t;
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() {
        logger.log(Level.INFO, "Creating commit timestamps table {0}", TableId.of(this.databaseId, this.commitTimestampsTable));
        String createTable = String.format(CREATE_TABLE_STATEMENT, this.commitTimestampsTable, this.databaseCol, this.catalogCol, this.schemaCol, this.tableCol, this.shardIdBoolCol, this.shardIdBytesCol, this.shardIdDateCol, this.shardIdFloat64Col, this.shardIdInt64Col, this.shardIdStringCol, this.shardIdTimestampCol, this.tsCol, this.databaseCol, this.catalogCol, this.schemaCol, this.tableCol, this.shardIdBoolCol, this.shardIdBytesCol, this.shardIdDateCol, this.shardIdFloat64Col, this.shardIdInt64Col, this.shardIdStringCol, this.shardIdTimestampCol);
        boolean tableAlreadyBeingCreated = false;
        Set<String> set = RUNNING_CREATE_TABLE_STATEMENTS;
        synchronized (set) {
            tableAlreadyBeingCreated = RUNNING_CREATE_TABLE_STATEMENTS.contains(createTable);
            if (!tableAlreadyBeingCreated) {
                RUNNING_CREATE_TABLE_STATEMENTS.add(createTable);
            }
        }
        if (tableAlreadyBeingCreated) {
            this.waitForTableCreationToFinish(createTable);
            return;
        }
        try {
            OperationFuture fut = this.adminClient.updateDatabaseDdl(this.databaseId.getInstanceId().getInstance(), this.databaseId.getDatabase(), Collections.singleton(createTable), null);
            try {
                fut.get();
                logger.log(Level.INFO, "Created commit timestamps table {0}", TableId.of(this.databaseId, this.commitTimestampsTable));
            }
            catch (ExecutionException e) {
                logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Could not create commit timestamps table {0}", (Object)TableId.of(this.databaseId, this.commitTimestampsTable), e));
                SpannerExceptionFactory.newSpannerException((Throwable)e.getCause());
            }
            catch (InterruptedException e) {
                logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Create commit timestamps table {0} interrupted", (Object)TableId.of(this.databaseId, this.commitTimestampsTable), e));
                SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
            }
        }
        finally {
            RUNNING_CREATE_TABLE_STATEMENTS.remove(createTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTableCreationToFinish(String createTable) {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
            }
            Set<String> set = RUNNING_CREATE_TABLE_STATEMENTS;
            synchronized (set) {
                if (!RUNNING_CREATE_TABLE_STATEMENTS.contains(createTable)) {
                    return;
                }
            }
        }
    }

    private void verifyTable() {
        Statement columnsStatement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)FIND_COLUMNS_STATEMENT).bind("catalog").to(this.commitTimestampsCatalog)).bind("schema").to(this.commitTimestampsSchema)).bind("table").to(this.commitTimestampsTable)).build();
        boolean foundDatabaseCol = false;
        boolean foundCatalogCol = false;
        boolean foundSchemaCol = false;
        boolean foundTableCol = false;
        boolean foundShardIdBoolCol = false;
        boolean foundShardIdBytesCol = false;
        boolean foundShardIdDateCol = false;
        boolean foundShardIdFloat64Col = false;
        boolean foundShardIdInt64Col = false;
        boolean foundShardIdStringCol = false;
        boolean foundShardIdTimestampCol = false;
        boolean foundTsCol = false;
        try (ResultSet rs = this.client.singleUse().executeQuery(columnsStatement, new Options.QueryOption[0]);){
            while (rs.next()) {
                String col = rs.getString("COLUMN_NAME");
                if (col.equalsIgnoreCase(this.databaseCol) || col.equalsIgnoreCase(this.catalogCol) || col.equalsIgnoreCase(this.schemaCol) || col.equalsIgnoreCase(this.tableCol)) {
                    if (!rs.getString("SPANNER_TYPE").startsWith("STRING")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Column %s is not of type STRING, but of type %s. Name columns must be of type STRING.", col, rs.getString("SPANNER_TYPE")));
                    }
                    foundDatabaseCol = foundDatabaseCol || col.equalsIgnoreCase(this.databaseCol);
                    foundCatalogCol = foundCatalogCol || col.equalsIgnoreCase(this.catalogCol);
                    foundSchemaCol = foundSchemaCol || col.equalsIgnoreCase(this.schemaCol);
                    foundTableCol = foundTableCol || col.equalsIgnoreCase(this.tableCol);
                    continue;
                }
                if (col.equalsIgnoreCase(this.shardIdBoolCol)) {
                    if (!rs.getString("SPANNER_TYPE").equals("BOOL")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Bool shard column %s is not of type BOOL, but of type %s", this.shardIdBoolCol, rs.getString("SPANNER_TYPE")));
                    }
                    foundShardIdBoolCol = true;
                    continue;
                }
                if (col.equalsIgnoreCase(this.shardIdBytesCol)) {
                    if (!rs.getString("SPANNER_TYPE").startsWith("BYTES")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Bytes shard column %s is not of type BYTES, but of type %s", this.shardIdBytesCol, rs.getString("SPANNER_TYPE")));
                    }
                    foundShardIdBytesCol = true;
                    continue;
                }
                if (col.equalsIgnoreCase(this.shardIdDateCol)) {
                    if (!rs.getString("SPANNER_TYPE").equals("DATE")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Date shard column %s is not of type DATE, but of type %s", this.shardIdDateCol, rs.getString("SPANNER_TYPE")));
                    }
                    foundShardIdDateCol = true;
                    continue;
                }
                if (col.equalsIgnoreCase(this.shardIdFloat64Col)) {
                    if (!rs.getString("SPANNER_TYPE").equals("FLOAT64")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Float64 shard column %s is not of type FLOAT64, but of type %s", this.shardIdFloat64Col, rs.getString("SPANNER_TYPE")));
                    }
                    foundShardIdFloat64Col = true;
                    continue;
                }
                if (col.equalsIgnoreCase(this.shardIdInt64Col)) {
                    if (!rs.getString("SPANNER_TYPE").equals("INT64")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Int64 shard column %s is not of type INT64, but of type %s", this.shardIdInt64Col, rs.getString("SPANNER_TYPE")));
                    }
                    foundShardIdInt64Col = true;
                    continue;
                }
                if (col.equalsIgnoreCase(this.shardIdStringCol)) {
                    if (!rs.getString("SPANNER_TYPE").startsWith("STRING")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("String shard column %s is not of type STRING, but of type %s", this.shardIdStringCol, rs.getString("SPANNER_TYPE")));
                    }
                    foundShardIdStringCol = true;
                    continue;
                }
                if (col.equalsIgnoreCase(this.shardIdTimestampCol)) {
                    if (!rs.getString("SPANNER_TYPE").equals("TIMESTAMP")) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Timestamp shard column %s is not of type TIMESTAMP, but of type %s", this.shardIdTimestampCol, rs.getString("SPANNER_TYPE")));
                    }
                    foundShardIdTimestampCol = true;
                    continue;
                }
                if (!col.equalsIgnoreCase(this.tsCol)) continue;
                if (!rs.getString("SPANNER_TYPE").equals("TIMESTAMP")) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Commit timestamp column %s is not of type TIMESTAMP, but of type %s", this.tsCol, rs.getString("SPANNER_TYPE")));
                }
                foundTsCol = true;
            }
        }
        if (!foundDatabaseCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Database name column %s not found", this.databaseCol));
        }
        if (!foundCatalogCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Catalog name column %s not found", this.catalogCol));
        }
        if (!foundSchemaCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Schema name column %s not found", this.schemaCol));
        }
        if (!foundTableCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Table name column %s not found", this.tableCol));
        }
        if (!foundShardIdBoolCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Bool shard column %s not found", this.shardIdBoolCol));
        }
        if (!foundShardIdBytesCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Bytes shard column %s not found", this.shardIdBytesCol));
        }
        if (!foundShardIdDateCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Date shard column %s not found", this.shardIdDateCol));
        }
        if (!foundShardIdFloat64Col) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Float64 shard column %s not found", this.shardIdFloat64Col));
        }
        if (!foundShardIdInt64Col) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Int64 shard column %s not found", this.shardIdInt64Col));
        }
        if (!foundShardIdStringCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("String shard column %s not found", this.shardIdStringCol));
        }
        if (!foundShardIdTimestampCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Timestamp shard column %s not found", this.shardIdTimestampCol));
        }
        if (!foundTsCol) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Commit timestamp column %s not found", this.tsCol));
        }
        Statement pkStatement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)FIND_PK_COLUMNS_STATEMENT).bind("catalog").to(this.commitTimestampsCatalog)).bind("schema").to(this.commitTimestampsSchema)).bind("table").to(this.commitTimestampsTable)).build();
        String[] expectedCols = new String[]{this.databaseCol, this.catalogCol, this.schemaCol, this.tableCol, this.shardIdBoolCol, this.shardIdBytesCol, this.shardIdDateCol, this.shardIdFloat64Col, this.shardIdInt64Col, this.shardIdStringCol, this.shardIdTimestampCol};
        int index = 0;
        try (ResultSet rs = this.client.singleUse().executeQuery(pkStatement, new Options.QueryOption[0]);){
            while (rs.next()) {
                if (!expectedCols[index].equalsIgnoreCase(rs.getString(0))) {
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)String.format("Expected column `%s` as column number %d of the primary key of the table `%s`, but instead column `%s` was found as column number %d of the primary key.", expectedCols[index], index + 1, this.commitTimestampsTable, rs.getString(0), index + 1));
                }
                ++index;
            }
            if (index < expectedCols.length) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Table %s does has a primary key with too few columns. The primary key of the table must be (`%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`, `%s`).", this.commitTimestampsTable, this.databaseCol, this.catalogCol, this.schemaCol, this.tableCol, this.shardIdBoolCol, this.shardIdBytesCol, this.shardIdDateCol, this.shardIdFloat64Col, this.shardIdInt64Col, this.shardIdStringCol, this.shardIdTimestampCol));
            }
        }
    }

    @Override
    public Timestamp get(TableId table) {
        return this.internalGet(table, null);
    }

    @Override
    public Timestamp get(TableId table, Value shardValue) {
        return this.internalGet(table, shardValue);
    }

    private Timestamp internalGet(TableId table, Value shardValue) {
        Preconditions.checkNotNull((Object)table);
        if (!this.initialized) {
            this.initialize();
        }
        Type.Code t = shardValue == null ? null : shardValue.getType().getCode();
        Struct row = this.client.singleUse().readRow(this.commitTimestampsTable, Key.of((Object[])new Object[]{table.getDatabaseId().getName(), table.getCatalog(), table.getSchema(), table.getTable(), t == Type.Code.BOOL ? Boolean.valueOf(shardValue.getBool()) : null, t == Type.Code.BYTES ? shardValue.getBytes() : null, t == Type.Code.DATE ? shardValue.getDate() : null, t == Type.Code.FLOAT64 ? Double.valueOf(shardValue.getFloat64()) : null, t == Type.Code.INT64 ? Long.valueOf(shardValue.getInt64()) : null, SpannerCommitTimestampRepository.shardValueToString(t, shardValue), t == Type.Code.TIMESTAMP ? shardValue.getTimestamp() : null}), this.tsColumns);
        if (row == null) {
            return this.initialCommitTimestamp;
        }
        return row.getTimestamp(0);
    }

    @Override
    public void set(TableId table, Timestamp commitTimestamp) {
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkNotNull((Object)commitTimestamp);
        this.internalSet(table, null, commitTimestamp);
    }

    @Override
    public void set(TableId table, Value shardValue, Timestamp commitTimestamp) {
        this.internalSet(table, shardValue, commitTimestamp);
    }

    private void internalSet(TableId table, Value shardValue, Timestamp commitTimestamp) {
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkNotNull((Object)commitTimestamp);
        if (!this.initialized) {
            this.initialize();
        }
        Type.Code t = shardValue == null ? null : shardValue.getType().getCode();
        this.client.writeAtLeastOnce(Collections.singleton(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)this.commitTimestampsTable).set(this.databaseCol).to(table.getDatabaseId().getName())).set(this.catalogCol).to(table.getCatalog())).set(this.schemaCol).to(table.getSchema())).set(this.tableCol).to(table.getTable())).set(this.shardIdBoolCol).to(t == Type.Code.BOOL ? Boolean.valueOf(shardValue.getBool()) : null)).set(this.shardIdBytesCol).to(t == Type.Code.BYTES ? shardValue.getBytes() : null)).set(this.shardIdDateCol).to(t == Type.Code.DATE ? shardValue.getDate() : null)).set(this.shardIdFloat64Col).to(t == Type.Code.FLOAT64 ? Double.valueOf(shardValue.getFloat64()) : null)).set(this.shardIdInt64Col).to(t == Type.Code.INT64 ? Long.valueOf(shardValue.getInt64()) : null)).set(this.shardIdStringCol).to(SpannerCommitTimestampRepository.shardValueToString(t, shardValue))).set(this.shardIdTimestampCol).to(t == Type.Code.TIMESTAMP ? shardValue.getTimestamp() : null)).set(this.tsCol).to(commitTimestamp)).build()));
    }

    static String shardValueToString(Type.Code type, Value shardValue) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case ARRAY: {
                return SpannerCommitTimestampRepository.arrayToString(shardValue);
            }
            case NUMERIC: {
                return shardValue.getNumeric().toString();
            }
            case JSON: {
                return shardValue.getJson();
            }
            case STRING: {
                return shardValue.getString();
            }
        }
        return null;
    }

    static String arrayToString(Value value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.getType().getCode() == Type.Code.ARRAY ? 1 : 0) != 0);
        switch (value.getType().getArrayElementType().getCode()) {
            case BOOL: {
                return value.getBoolArray().stream().map(b -> b.toString()).collect(Collectors.joining(","));
            }
            case BYTES: {
                return value.getBytesArray().stream().map(b -> b.toBase64()).collect(Collectors.joining(","));
            }
            case DATE: {
                return value.getDateArray().stream().map(b -> b.toString()).collect(Collectors.joining(","));
            }
            case FLOAT64: {
                return value.getFloat64Array().stream().map(b -> b.toString()).collect(Collectors.joining(","));
            }
            case INT64: {
                return value.getInt64Array().stream().map(b -> b.toString()).collect(Collectors.joining(","));
            }
            case JSON: {
                return value.getJsonArray().stream().map(b -> Base64.getEncoder().encodeToString(b.getBytes(UTF8))).collect(Collectors.joining(","));
            }
            case NUMERIC: {
                return value.getNumericArray().stream().map(b -> b.toString()).collect(Collectors.joining(","));
            }
            case STRING: {
                return value.getStringArray().stream().map(b -> Base64.getEncoder().encodeToString(b.getBytes(UTF8))).collect(Collectors.joining(","));
            }
            case TIMESTAMP: {
                return value.getTimestampArray().stream().map(b -> b.toString()).collect(Collectors.joining(","));
            }
        }
        return null;
    }

    public static class Builder {
        private final Spanner spanner;
        private final DatabaseId databaseId;
        private boolean createTableIfNotExists = true;
        private String commitTimestampsCatalog = "";
        private String commitTimestampsSchema = "";
        private String commitTimestampsTable = "LAST_SEEN_COMMIT_TIMESTAMPS";
        private String databaseCol = "DATABASE_NAME";
        private String catalogCol = "TABLE_CATALOG";
        private String schemaCol = "TABLE_SCHEMA";
        private String tableCol = "TABLE_NAME";
        private String shardIdBoolCol = "SHARD_ID_BOOL";
        private String shardIdBytesCol = "SHARD_ID_BYTES";
        private String shardIdDateCol = "SHARD_ID_DATE";
        private String shardIdFloat64Col = "SHARD_ID_FLOAT64";
        private String shardIdInt64Col = "SHARD_ID_INT64";
        private String shardIdStringCol = "SHARD_ID_STRING";
        private String shardIdTimestampCol = "SHARD_ID_TIMESTAMP";
        private String tsCol = "LAST_SEEN_COMMIT_TIMESTAMP";
        private Timestamp initialCommitTimestamp;

        private Builder(Spanner spanner, DatabaseId databaseId) {
            this.spanner = (Spanner)Preconditions.checkNotNull((Object)spanner);
            this.databaseId = (DatabaseId)Preconditions.checkNotNull((Object)databaseId);
        }

        public Builder setCreateTableIfNotExists(boolean create) {
            this.createTableIfNotExists = create;
            return this;
        }

        public Builder setCommitTimestampsTable(String table) {
            this.commitTimestampsTable = (String)Preconditions.checkNotNull((Object)table);
            return this;
        }

        public Builder setDatabaseNameColumn(String column) {
            this.databaseCol = (String)Preconditions.checkNotNull((Object)column);
            return this;
        }

        public Builder setCatalogNameColumn(String column) {
            this.catalogCol = (String)Preconditions.checkNotNull((Object)column);
            return this;
        }

        public Builder setSchemaNameColumn(String column) {
            this.schemaCol = (String)Preconditions.checkNotNull((Object)column);
            return this;
        }

        public Builder setTableNameColumn(String column) {
            this.tableCol = (String)Preconditions.checkNotNull((Object)column);
            return this;
        }

        public Builder setShardIdBoolColumn(String column) {
            this.shardIdBoolCol = column;
            return this;
        }

        public Builder setShardIdBytesColumn(String column) {
            this.shardIdBytesCol = column;
            return this;
        }

        public Builder setShardIdDateColumn(String column) {
            this.shardIdDateCol = column;
            return this;
        }

        public Builder setShardIdFloat64Column(String column) {
            this.shardIdFloat64Col = column;
            return this;
        }

        public Builder setShardIdInt64Column(String column) {
            this.shardIdInt64Col = column;
            return this;
        }

        public Builder setShardIdStringColumn(String column) {
            this.shardIdStringCol = column;
            return this;
        }

        public Builder setShardIdTimestampColumn(String column) {
            this.shardIdTimestampCol = column;
            return this;
        }

        public Builder setCommitTimestampColumn(String column) {
            this.tsCol = (String)Preconditions.checkNotNull((Object)column);
            return this;
        }

        public Builder setInitialCommitTimestamp(@Nullable Timestamp initial) {
            this.initialCommitTimestamp = initial;
            return this;
        }

        public SpannerCommitTimestampRepository build() {
            return new SpannerCommitTimestampRepository(this);
        }
    }
}

