/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.client.util.Preconditions;
import com.google.cloud.spanner.DatabaseId;
import com.google.common.base.Strings;
import java.util.Objects;

public final class TableId {
    private final DatabaseId databaseId;
    private final String catalog;
    private final String schema;
    private final String table;
    private final String sqlIdentifier;
    private final String fullName;

    static Builder newBuilder(DatabaseId databaseId, String table) {
        return new Builder(databaseId, table);
    }

    public static TableId of(DatabaseId databaseId, String table) {
        return TableId.newBuilder(databaseId, table).build();
    }

    private TableId(Builder builder) {
        this.databaseId = builder.databaseId;
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.table = builder.table;
        StringBuilder id = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.catalog)) {
            id.append("`").append(this.catalog).append("`.");
        }
        if (!Strings.isNullOrEmpty((String)this.schema)) {
            id.append("`").append(this.schema).append("`.");
        }
        id.append("`").append(this.table).append("`");
        this.sqlIdentifier = id.toString();
        this.fullName = this.databaseId.getName() + "/" + this.sqlIdentifier;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return Objects.hash(this.databaseId, this.catalog, this.schema, this.table);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableId)) {
            return false;
        }
        TableId other = (TableId)o;
        return Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.catalog, other.catalog) && Objects.equals(this.schema, other.schema) && Objects.equals(this.table, other.table);
    }

    static class Builder {
        private final DatabaseId databaseId;
        private final String table;
        private String catalog = "";
        private String schema = "";

        private Builder(DatabaseId databaseId, String table) {
            this.databaseId = (DatabaseId)Preconditions.checkNotNull((Object)databaseId);
            this.table = (String)Preconditions.checkNotNull((Object)table);
        }

        Builder setCatalog(String catalog) {
            this.catalog = (String)Preconditions.checkNotNull((Object)catalog);
            return this;
        }

        Builder setSchema(String schema) {
            this.schema = (String)Preconditions.checkNotNull((Object)schema);
            return this;
        }

        TableId build() {
            return new TableId(this);
        }
    }
}

