/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Value;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.UUID;
import java.util.concurrent.Executor;

public class DatabaseClientWithChangeSets
implements DatabaseClient {
    private final DatabaseClient client;
    private final String changeSetTable;
    private final String changeSetIdColumn;
    private final String changeSetCommitTSColumn;
    private final ChangeSetIdGenerator idGenerator;

    public static DatabaseClientWithChangeSets of(DatabaseClient client) {
        return new DatabaseClientWithChangeSets(client, "CHANGE_SETS", "CHANGE_SET_ID", "COMMIT_TIMESTAMP", RandomUUIDChangeSetIdGenerator.INSTANCE);
    }

    private DatabaseClientWithChangeSets(DatabaseClient client, String changeSetTable, String changeSetIdColumn, String changeSetCommitTSColumn, ChangeSetIdGenerator idGenerator) {
        this.client = client;
        this.changeSetTable = changeSetTable;
        this.changeSetIdColumn = changeSetIdColumn;
        this.changeSetCommitTSColumn = changeSetCommitTSColumn;
        this.idGenerator = idGenerator;
    }

    public String newChangeSetId() {
        return this.idGenerator.generateChangeSetId();
    }

    boolean containsChangeSetOperation(Iterable<Mutation> mutations) {
        for (Mutation m : mutations) {
            if (!m.getTable().equals(this.changeSetTable) || m.getOperation() != Mutation.Op.INSERT && m.getOperation() != Mutation.Op.INSERT_OR_UPDATE) continue;
            return true;
        }
        return false;
    }

    Mutation createChangeSetMutation(String changeSetId) {
        return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)this.changeSetTable).set(this.changeSetIdColumn).to(changeSetId)).set(this.changeSetCommitTSColumn).to(Value.COMMIT_TIMESTAMP)).build();
    }

    Iterable<Mutation> appendChangeSetMutation(Iterable<Mutation> mutations, String changeSetId) {
        return Iterables.concat(mutations, (Iterable)ImmutableList.of((Object)this.createChangeSetMutation(changeSetId)));
    }

    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        return this.client.write(mutations);
    }

    public Timestamp write(String changeSetId, Iterable<Mutation> mutations) throws SpannerException {
        return this.write(this.appendChangeSetMutation(mutations, changeSetId));
    }

    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        return this.client.writeAtLeastOnce(mutations);
    }

    public Timestamp writeAtLeastOnce(String changeSetId, Iterable<Mutation> mutations) throws SpannerException {
        return this.writeAtLeastOnce(this.appendChangeSetMutation(mutations, changeSetId));
    }

    public TransactionRunnerWithChangeSet readWriteTransaction(Options.TransactionOption ... options) {
        return new TransactionRunnerWithChangeSetImpl(this.client.readWriteTransaction(options));
    }

    public TransactionManagerWithChangeSet transactionManager(Options.TransactionOption ... options) {
        return new TransactionManagerWithChangeSetImpl(this.client.transactionManager(options));
    }

    public AsyncRunnerWithChangeSet runAsync(Options.TransactionOption ... options) {
        return new AsyncRunnerWithChangeSetImpl(this.client.runAsync(options));
    }

    public AsyncTransactionManagerWithChangeSet transactionManagerAsync(Options.TransactionOption ... options) {
        return new AsyncTransactionManagerWithChangeSetImpl(this.client.transactionManagerAsync(options));
    }

    public ReadContext singleUse() {
        return this.client.singleUse();
    }

    public ReadContext singleUse(TimestampBound bound) {
        return this.client.singleUse(bound);
    }

    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return this.client.singleUseReadOnlyTransaction();
    }

    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return this.client.singleUseReadOnlyTransaction(bound);
    }

    public ReadOnlyTransaction readOnlyTransaction() {
        return this.client.readOnlyTransaction();
    }

    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return this.client.readOnlyTransaction(bound);
    }

    public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
        return this.client.executePartitionedUpdate(stmt, options);
    }

    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        return this.client.writeWithOptions(mutations, options);
    }

    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        return this.client.writeAtLeastOnceWithOptions(mutations, options);
    }

    class AsyncTransactionManagerWithChangeSetImpl
    extends AbstractChangeSetTransaction
    implements AsyncTransactionManagerWithChangeSet {
        final AsyncTransactionManager manager;

        AsyncTransactionManagerWithChangeSetImpl(AsyncTransactionManager manager) {
            this.manager = manager;
        }

        public AsyncTransactionManager.TransactionContextFuture beginAsync() {
            AsyncTransactionManager.TransactionContextFuture context = this.manager.beginAsync();
            ApiFutures.addCallback((ApiFuture)context, (ApiFutureCallback)new ApiFutureCallback<TransactionContext>(){

                public void onFailure(Throwable t) {
                }

                public void onSuccess(TransactionContext context) {
                    context.buffer(DatabaseClientWithChangeSets.this.createChangeSetMutation(AsyncTransactionManagerWithChangeSetImpl.this.changeSetId));
                }
            }, (Executor)MoreExecutors.directExecutor());
            return context;
        }

        public ApiFuture<Void> rollbackAsync() {
            return this.manager.rollbackAsync();
        }

        public AsyncTransactionManager.TransactionContextFuture resetForRetryAsync() {
            AsyncTransactionManager.TransactionContextFuture context = this.manager.resetForRetryAsync();
            ApiFutures.addCallback((ApiFuture)context, (ApiFutureCallback)new ApiFutureCallback<TransactionContext>(){

                public void onFailure(Throwable t) {
                }

                public void onSuccess(TransactionContext context) {
                    context.buffer(DatabaseClientWithChangeSets.this.createChangeSetMutation(AsyncTransactionManagerWithChangeSetImpl.this.changeSetId));
                }
            }, (Executor)MoreExecutors.directExecutor());
            return context;
        }

        public TransactionManager.TransactionState getState() {
            return this.manager.getState();
        }

        public void close() {
            this.manager.close();
        }

        public ApiFuture<Void> closeAsync() {
            return this.manager.closeAsync();
        }
    }

    class AsyncRunnerWithChangeSetImpl
    extends AbstractChangeSetTransaction
    implements AsyncRunnerWithChangeSet {
        final AsyncRunner runner;

        AsyncRunnerWithChangeSetImpl(AsyncRunner runner) {
            this.runner = runner;
        }

        public <R> ApiFuture<R> runAsync(final AsyncRunner.AsyncWork<R> work, Executor executor) {
            return this.runner.runAsync(new AsyncRunner.AsyncWork<R>(){

                public ApiFuture<R> doWorkAsync(TransactionContext txn) {
                    txn.buffer(DatabaseClientWithChangeSets.this.createChangeSetMutation(AsyncRunnerWithChangeSetImpl.this.changeSetId));
                    return work.doWorkAsync(txn);
                }
            }, executor);
        }

        public ApiFuture<Timestamp> getCommitTimestamp() {
            return this.runner.getCommitTimestamp();
        }
    }

    class TransactionManagerWithChangeSetImpl
    extends AbstractChangeSetTransaction
    implements TransactionManagerWithChangeSet {
        final TransactionManager manager;

        TransactionManagerWithChangeSetImpl(TransactionManager manager) {
            this.manager = manager;
        }

        public TransactionContext begin() {
            TransactionContext context = this.manager.begin();
            context.buffer(DatabaseClientWithChangeSets.this.createChangeSetMutation(this.changeSetId));
            return context;
        }

        public void commit() {
            this.manager.commit();
        }

        public void rollback() {
            this.manager.rollback();
        }

        public TransactionContext resetForRetry() {
            TransactionContext context = this.manager.resetForRetry();
            context.buffer(DatabaseClientWithChangeSets.this.createChangeSetMutation(this.changeSetId));
            return context;
        }

        public Timestamp getCommitTimestamp() {
            return this.manager.getCommitTimestamp();
        }

        public TransactionManager.TransactionState getState() {
            return this.manager.getState();
        }

        public void close() {
            this.manager.close();
        }
    }

    class TransactionRunnerWithChangeSetImpl
    extends AbstractChangeSetTransaction
    implements TransactionRunnerWithChangeSet {
        final TransactionRunner runner;

        TransactionRunnerWithChangeSetImpl(TransactionRunner runner) {
            this.runner = runner;
        }

        public <T> T run(final TransactionRunner.TransactionCallable<T> callable) {
            return (T)this.runner.run(new TransactionRunner.TransactionCallable<T>(){

                public T run(TransactionContext transaction) throws Exception {
                    transaction.buffer(DatabaseClientWithChangeSets.this.createChangeSetMutation(TransactionRunnerWithChangeSetImpl.this.changeSetId));
                    return callable.run(transaction);
                }
            });
        }

        public Timestamp getCommitTimestamp() {
            return this.runner.getCommitTimestamp();
        }

        public TransactionRunner allowNestedTransaction() {
            return this.runner.allowNestedTransaction();
        }
    }

    abstract class AbstractChangeSetTransaction
    implements ChangeSetIdSupplier {
        final String changeSetId;

        AbstractChangeSetTransaction() {
            this.changeSetId = DatabaseClientWithChangeSets.this.idGenerator.generateChangeSetId();
        }

        @Override
        public String getChangeSetId() {
            return this.changeSetId;
        }
    }

    static class RandomUUIDChangeSetIdGenerator
    implements ChangeSetIdGenerator {
        static final RandomUUIDChangeSetIdGenerator INSTANCE = new RandomUUIDChangeSetIdGenerator();

        private RandomUUIDChangeSetIdGenerator() {
        }

        @Override
        public String generateChangeSetId() {
            return UUID.randomUUID().toString();
        }
    }

    public static interface AsyncTransactionManagerWithChangeSet
    extends AsyncTransactionManager,
    ChangeSetIdSupplier {
    }

    public static interface AsyncRunnerWithChangeSet
    extends AsyncRunner,
    ChangeSetIdSupplier {
    }

    public static interface TransactionManagerWithChangeSet
    extends TransactionManager,
    ChangeSetIdSupplier {
    }

    public static interface TransactionRunnerWithChangeSet
    extends TransactionRunner,
    ChangeSetIdSupplier {
    }

    public static interface ChangeSetIdSupplier {
        public String getChangeSetId();
    }

    public static interface ChangeSetIdGenerator {
        public String generateChangeSetId();
    }
}

