/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ApiService;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.watcher.CommitTimestampRepository;
import com.google.cloud.spanner.watcher.RowImpl;
import com.google.cloud.spanner.watcher.ShardProvider;
import com.google.cloud.spanner.watcher.SpannerCommitTimestampRepository;
import com.google.cloud.spanner.watcher.SpannerTableChangeWatcher;
import com.google.cloud.spanner.watcher.SpannerUtils;
import com.google.cloud.spanner.watcher.TableId;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class SpannerTableTailer
extends AbstractApiService
implements SpannerTableChangeWatcher {
    static final Logger logger = Logger.getLogger(SpannerTableTailer.class.getName());
    static final String POLL_QUERY = "SELECT *\nFROM %s\nWHERE `%s`>@prevCommitTimestamp";
    static final String POLL_QUERY_ORDER_BY = "\nORDER BY `%s`";
    private final Object lock = new Object();
    private ScheduledFuture<?> scheduled;
    private ApiFuture<Void> currentPollFuture;
    private final DatabaseClient client;
    private final TableId table;
    private final ShardProvider shardProvider;
    private final List<SpannerTableChangeWatcher.RowChangeCallback> callbacks = new LinkedList<SpannerTableChangeWatcher.RowChangeCallback>();
    private final CommitTimestampRepository commitTimestampRepository;
    private final Duration pollInterval;
    private final ScheduledExecutorService executor;
    private final boolean isOwnedExecutor;
    private Timestamp startedPollWithCommitTimestamp;
    private Timestamp lastSeenCommitTimestamp;
    private String commitTimestampColumn;

    public static Builder newBuilder(Spanner spanner, TableId table) {
        return new Builder(spanner, table);
    }

    private SpannerTableTailer(Builder builder) {
        this.client = builder.spanner.getDatabaseClient(builder.table.getDatabaseId());
        this.table = builder.table;
        this.shardProvider = builder.shardProvider;
        this.commitTimestampRepository = builder.commitTimestampRepository;
        this.pollInterval = builder.pollInterval;
        this.executor = builder.executor == null ? Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("spanner-tailer-" + this.table + "-%d").build()) : builder.executor;
        boolean bl = this.isOwnedExecutor = builder.executor == null;
        if (builder.commitTimestampColumn != null) {
            this.commitTimestampColumn = builder.commitTimestampColumn;
        }
    }

    @Override
    public void addCallback(SpannerTableChangeWatcher.RowChangeCallback callback) {
        Preconditions.checkState((this.state() == ApiService.State.NEW ? 1 : 0) != 0);
        this.callbacks.add(callback);
    }

    @Override
    public TableId getTable() {
        return this.table;
    }

    protected void doStart() {
        logger.log(Level.INFO, "Starting watcher for table {0}", this.table);
        final ApiFuture<String> commitTimestampColFut = this.commitTimestampColumn == null ? SpannerUtils.getTimestampColumn(this.client, this.table) : ApiFutures.immediateFuture((Object)this.commitTimestampColumn);
        commitTimestampColFut.addListener(new Runnable(){

            @Override
            public void run() {
                logger.log(Level.INFO, "Initializing watcher for table {0}", SpannerTableTailer.this.table);
                try {
                    if (SpannerTableTailer.this.shardProvider == null) {
                        SpannerTableTailer.this.lastSeenCommitTimestamp = SpannerTableTailer.this.commitTimestampRepository.get(SpannerTableTailer.this.table);
                    } else {
                        SpannerTableTailer.this.lastSeenCommitTimestamp = SpannerTableTailer.this.commitTimestampRepository.get(SpannerTableTailer.this.table, SpannerTableTailer.this.shardProvider.getShardValue());
                    }
                    SpannerTableTailer.this.commitTimestampColumn = (String)Futures.getUnchecked((Future)commitTimestampColFut);
                    logger.log(Level.INFO, "Watcher started for table {0}", SpannerTableTailer.this.table);
                    SpannerTableTailer.this.notifyStarted();
                    SpannerTableTailer.this.scheduled = SpannerTableTailer.this.executor.schedule(new SpannerTailerRunner(), 0L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Could not initialize watcher for table {0}", (Object)SpannerTableTailer.this.table, t));
                    SpannerTableTailer.this.notifyFailed(t);
                }
            }
        }, (Executor)this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFailed(Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOwnedExecutor) {
                this.executor.shutdown();
            }
        }
        super.notifyFailed(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduled == null || this.scheduled.cancel(false)) {
                if (this.isOwnedExecutor) {
                    this.executor.shutdown();
                }
                this.notifyStopped();
            }
        }
    }

    class SpannerTailerRunner
    implements Runnable {
        SpannerTailerRunner() {
        }

        @Override
        public void run() {
            logger.log(Level.FINE, String.format("Starting poll for commit timestamp %s", SpannerTableTailer.this.lastSeenCommitTimestamp.toString()));
            SpannerTableTailer.this.startedPollWithCommitTimestamp = SpannerTableTailer.this.lastSeenCommitTimestamp;
            Statement.Builder statementBuilder = Statement.newBuilder((String)String.format(SpannerTableTailer.POLL_QUERY, SpannerTableTailer.this.table.getSqlIdentifier(), SpannerTableTailer.this.commitTimestampColumn));
            if (SpannerTableTailer.this.shardProvider != null) {
                SpannerTableTailer.this.shardProvider.appendShardFilter(statementBuilder);
            }
            statementBuilder.append(String.format(SpannerTableTailer.POLL_QUERY_ORDER_BY, SpannerTableTailer.this.commitTimestampColumn));
            try (AsyncResultSet rs = SpannerTableTailer.this.client.singleUse().executeQueryAsync(((Statement.Builder)statementBuilder.bind("prevCommitTimestamp").to(SpannerTableTailer.this.lastSeenCommitTimestamp)).build(), new Options.QueryOption[0]);){
                SpannerTableTailer.this.currentPollFuture = rs.setCallback((Executor)SpannerTableTailer.this.executor, (AsyncResultSet.ReadyCallback)new SpannerTailerCallback());
            }
        }
    }

    class SpannerTailerCallback
    implements AsyncResultSet.ReadyCallback {
        SpannerTailerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNextPollOrStop() {
            if (SpannerTableTailer.this.lastSeenCommitTimestamp.compareTo(SpannerTableTailer.this.startedPollWithCommitTimestamp) > 0) {
                if (SpannerTableTailer.this.shardProvider == null) {
                    SpannerTableTailer.this.commitTimestampRepository.set(SpannerTableTailer.this.table, SpannerTableTailer.this.lastSeenCommitTimestamp);
                } else {
                    SpannerTableTailer.this.commitTimestampRepository.set(SpannerTableTailer.this.table, SpannerTableTailer.this.shardProvider.getShardValue(), SpannerTableTailer.this.lastSeenCommitTimestamp);
                }
            }
            Object object = SpannerTableTailer.this.lock;
            synchronized (object) {
                if (SpannerTableTailer.this.state() == ApiService.State.RUNNING) {
                    SpannerTableTailer.this.currentPollFuture.addListener(new Runnable(){

                        @Override
                        public void run() {
                            SpannerTableTailer.this.scheduled = SpannerTableTailer.this.executor.schedule(new SpannerTailerRunner(), SpannerTableTailer.this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
                        }
                    }, MoreExecutors.directExecutor());
                } else {
                    if (SpannerTableTailer.this.isOwnedExecutor) {
                        SpannerTableTailer.this.executor.shutdown();
                    }
                    if (SpannerTableTailer.this.state() == ApiService.State.STOPPING) {
                        SpannerTableTailer.this.currentPollFuture.addListener(new Runnable(){

                            @Override
                            public void run() {
                                SpannerTableTailer.this.notifyStopped();
                            }
                        }, MoreExecutors.directExecutor());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
            try {
                while (true) {
                    Object object = SpannerTableTailer.this.lock;
                    synchronized (object) {
                        if (SpannerTableTailer.this.state() != ApiService.State.RUNNING) {
                            this.scheduleNextPollOrStop();
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                    }
                    switch (resultSet.tryNext()) {
                        case DONE: {
                            this.scheduleNextPollOrStop();
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case OK: {
                            Timestamp ts = resultSet.getTimestamp(SpannerTableTailer.this.commitTimestampColumn);
                            RowImpl row = new RowImpl((ResultSet)resultSet);
                            for (SpannerTableChangeWatcher.RowChangeCallback callback : SpannerTableTailer.this.callbacks) {
                                callback.rowChange(SpannerTableTailer.this.table, row, ts);
                            }
                            if (ts.compareTo(SpannerTableTailer.this.lastSeenCommitTimestamp) <= 0) break;
                            SpannerTableTailer.this.lastSeenCommitTimestamp = ts;
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Error processing change set for table {0}", (Object)SpannerTableTailer.this.table, t));
                SpannerTableTailer.this.notifyFailed(t);
                this.scheduleNextPollOrStop();
                return AsyncResultSet.CallbackResponse.DONE;
            }
        }
    }

    public static class Builder {
        private final Spanner spanner;
        private final TableId table;
        private ShardProvider shardProvider;
        private CommitTimestampRepository commitTimestampRepository;
        private Duration pollInterval = Duration.ofSeconds((long)1L);
        private ScheduledExecutorService executor;
        private String commitTimestampColumn;

        private Builder(Spanner spanner, TableId table) {
            this.spanner = (Spanner)Preconditions.checkNotNull((Object)spanner);
            this.table = (TableId)Preconditions.checkNotNull((Object)table);
            this.commitTimestampRepository = SpannerCommitTimestampRepository.newBuilder(spanner, table.getDatabaseId()).build();
        }

        public Builder setShardProvider(ShardProvider provider) {
            this.shardProvider = provider;
            return this;
        }

        public Builder setCommitTimestampRepository(CommitTimestampRepository repository) {
            this.commitTimestampRepository = (CommitTimestampRepository)Preconditions.checkNotNull((Object)repository);
            return this;
        }

        public Builder setPollInterval(Duration interval) {
            this.pollInterval = (Duration)Preconditions.checkNotNull((Object)interval);
            return this;
        }

        public Builder setExecutor(ScheduledExecutorService executor) {
            this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
            return this;
        }

        public Builder setCommitTimestampColumn(String column) {
            this.commitTimestampColumn = column;
            return this;
        }

        public SpannerTableTailer build() {
            return new SpannerTableTailer(this);
        }
    }
}

