/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.core.ApiFunction;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.watcher.RandomResultSetGenerator;
import com.google.cloud.spanner.watcher.TimebasedShardProvider;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class AbstractMockServerTest {
    private static final Statement FIND_LAST_SEEN_COMMIT_TIMESTAMPS_TABLE_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_CATALOG=@catalog\nAND TABLE_SCHEMA=@schema\nAND TABLE_NAME=@table").bind("catalog").to("")).bind("schema").to("")).bind("table").to("LAST_SEEN_COMMIT_TIMESTAMPS")).build();
    private static final Statement FIND_LAST_SEEN_COMMIT_TIMESTAMPS_COLUMNS_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT COLUMN_NAME, SPANNER_TYPE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_CATALOG=@catalog\nAND TABLE_SCHEMA=@schema\nAND TABLE_NAME=@table\nORDER BY ORDINAL_POSITION").bind("catalog").to("")).bind("schema").to("")).bind("table").to("LAST_SEEN_COMMIT_TIMESTAMPS")).build();
    private static final Statement FIND_LAST_SEEN_COMMIT_TIMESTAMPS_PK_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT INDEX_COLUMNS.COLUMN_NAME\nFROM INFORMATION_SCHEMA.INDEXES\nINNER JOIN INFORMATION_SCHEMA.INDEX_COLUMNS \n            ON  INDEXES.TABLE_CATALOG=INDEX_COLUMNS.TABLE_CATALOG\n            AND INDEXES.TABLE_SCHEMA=INDEX_COLUMNS.TABLE_SCHEMA\n            AND INDEXES.TABLE_NAME=INDEX_COLUMNS.TABLE_NAME\n            AND INDEXES.INDEX_NAME=INDEX_COLUMNS.INDEX_NAME\nWHERE INDEXES.TABLE_CATALOG=@catalog\nAND INDEXES.TABLE_SCHEMA=@schema\nAND INDEXES.TABLE_NAME=@table\nAND INDEXES.INDEX_TYPE='PRIMARY_KEY'\nORDER BY INDEX_COLUMNS.ORDINAL_POSITION").bind("catalog").to("")).bind("schema").to("")).bind("table").to("LAST_SEEN_COMMIT_TIMESTAMPS")).build();
    private static final Statement GET_LAST_COMMIT_TIMESTAMP_STATEMENT = Statement.of((String)String.format("SELECT %s FROM %s WHERE ID=1", "LAST_SEEN_COMMIT_TIMESTAMP", "LAST_SEEN_COMMIT_TIMESTAMPS"));
    private static final ResultSetMetadata FIND_LAST_SEEN_COMMIT_TIMESTAMPS_TABLE_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("TABLE_NAME").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build();
    private static final ResultSet FIND_LAST_SEEN_COMMIT_TIMESTAMPS_TABLE_RESULTS = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("LAST_SEEN_COMMIT_TIMESTAMPS").build()).build()).setMetadata(FIND_LAST_SEEN_COMMIT_TIMESTAMPS_TABLE_METADATA).build();
    private static final ResultSetMetadata FIND_LAST_SEEN_COMMIT_TIMESTAMPS_COLUMNS_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COLUMN_NAME").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).addFields(StructType.Field.newBuilder().setName("SPANNER_TYPE").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build();
    private static final ResultSet FIND_LAST_SEEN_COMMIT_TIMESTAMPS_COLUMNS_RESULTS = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("DATABASE_NAME").build()).addValues(Value.newBuilder().setStringValue("STRING(MAX)").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("TABLE_CATALOG").build()).addValues(Value.newBuilder().setStringValue("STRING(MAX)").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("TABLE_SCHEMA").build()).addValues(Value.newBuilder().setStringValue("STRING(MAX)").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("TABLE_NAME").build()).addValues(Value.newBuilder().setStringValue("STRING(MAX)").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_BOOL").build()).addValues(Value.newBuilder().setStringValue("BOOL").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_BYTES").build()).addValues(Value.newBuilder().setStringValue("BYTES(MAX)").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_DATE").build()).addValues(Value.newBuilder().setStringValue("DATE").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_FLOAT64").build()).addValues(Value.newBuilder().setStringValue("FLOAT64").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_INT64").build()).addValues(Value.newBuilder().setStringValue("INT64").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_STRING").build()).addValues(Value.newBuilder().setStringValue("STRING(MAX)").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_TIMESTAMP").build()).addValues(Value.newBuilder().setStringValue("TIMESTAMP").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("LAST_SEEN_COMMIT_TIMESTAMP").build()).addValues(Value.newBuilder().setStringValue("TIMESTAMP").build()).build()).setMetadata(FIND_LAST_SEEN_COMMIT_TIMESTAMPS_COLUMNS_METADATA).build();
    private static final ResultSetMetadata FIND_LAST_SEEN_COMMIT_TIMESTAMPS_PK_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COLUMN_NAME").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build();
    private static final ResultSet FIND_LAST_SEEN_COMMIT_TIMESTAMPS_PK_RESULTS = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("DATABASE_NAME").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("TABLE_CATALOG").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("TABLE_SCHEMA").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("TABLE_NAME").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_BOOL").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_BYTES").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_DATE").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_FLOAT64").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_INT64").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_STRING").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("SHARD_ID_TIMESTAMP").build()).build()).setMetadata(FIND_LAST_SEEN_COMMIT_TIMESTAMPS_PK_METADATA).build();
    private static final ResultSetMetadata GET_LAST_SEEN_COMMIT_TIMESTAMP_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("LAST_SEEN_COMMIT_TIMESTAMP").setType(Type.newBuilder().setCode(TypeCode.TIMESTAMP).build()).build()).build()).build();
    private static final ResultSet GET_LAST_SEEN_COMMIT_TIMESTAMP_RESULTS = ResultSet.newBuilder().setMetadata(GET_LAST_SEEN_COMMIT_TIMESTAMP_METADATA).build();
    private static final Statement FIND_ALL_TABLES_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_NAME NOT IN UNNEST(@excluded)\nAND (@allTables=TRUE OR TABLE_NAME IN UNNEST(@included))\nAND TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME IN (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.COLUMN_OPTIONS WHERE OPTION_NAME='allow_commit_timestamp' AND OPTION_VALUE='TRUE')").bind("excluded").toStringArray(Collections.emptyList())).bind("allTables").to(true)).bind("included").toStringArray(Collections.emptyList())).bind("schema").to("")).bind("catalog").to("")).build();
    private static final Statement FIND_ALL_TABLES_EXCEPT_FOO_AND_BAR_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_NAME NOT IN UNNEST(@excluded)\nAND (@allTables=TRUE OR TABLE_NAME IN UNNEST(@included))\nAND TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME IN (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.COLUMN_OPTIONS WHERE OPTION_NAME='allow_commit_timestamp' AND OPTION_VALUE='TRUE')").bind("excluded").toStringArray((Iterable)ImmutableList.of((Object)"Foo", (Object)"Bar"))).bind("allTables").to(true)).bind("included").toStringArray(Collections.emptyList())).bind("schema").to("")).bind("catalog").to("")).build();
    private static final ResultSetMetadata FIND_TABLES_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("TABLE_NAME").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build();
    private static final ResultSet FIND_ALL_TABLES_RESULT = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("Foo").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("Bar").build()).build()).setMetadata(FIND_TABLES_METADATA).build();
    private static final ResultSet FIND_ALL_TABLES_EXCEPT_FOO_AND_BAR_RESULT = ResultSet.newBuilder().setMetadata(FIND_TABLES_METADATA).build();
    private static final Statement FIND_FOO_BAR_NON_EXISTING_TABLE_TABLES_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_NAME NOT IN UNNEST(@excluded)\nAND (@allTables=TRUE OR TABLE_NAME IN UNNEST(@included))\nAND TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME IN (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.COLUMN_OPTIONS WHERE OPTION_NAME='allow_commit_timestamp' AND OPTION_VALUE='TRUE')").bind("excluded").toStringArray(Collections.emptyList())).bind("allTables").to(false)).bind("included").toStringArray(Arrays.asList("Foo", "Bar", "NonExistingTable"))).bind("schema").to("")).bind("catalog").to("")).build();
    private static final Statement FIND_NON_EXISTING_TABLE_TABLES_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_NAME NOT IN UNNEST(@excluded)\nAND (@allTables=TRUE OR TABLE_NAME IN UNNEST(@included))\nAND TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME IN (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.COLUMN_OPTIONS WHERE OPTION_NAME='allow_commit_timestamp' AND OPTION_VALUE='TRUE')").bind("excluded").toStringArray(Collections.emptyList())).bind("allTables").to(false)).bind("included").toStringArray(Arrays.asList("NonExistingTable"))).bind("schema").to("")).bind("catalog").to("")).build();
    private static final ResultSet FIND_NON_EXISTING_TABLE_RESULT = ResultSet.newBuilder().setMetadata(FIND_TABLES_METADATA).build();
    private static final ResultSetMetadata COLUMNS_OPTIONS_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COLUMN_NAME").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).addFields(StructType.Field.newBuilder().setName("OPTION_NAME").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).addFields(StructType.Field.newBuilder().setName("OPTION_VALUE").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build();
    private static final Statement COLUMN_OPTIONS_FOO_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT COLUMN_NAME, OPTION_NAME, OPTION_VALUE\nFROM INFORMATION_SCHEMA.COLUMN_OPTIONS\nWHERE TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME = @table").bind("catalog").to("")).bind("schema").to("")).bind("table").to("Foo")).build();
    public static final Statement SELECT_FOO_STATEMENT = ((Statement.Builder)Statement.newBuilder((String)String.format("SELECT *\nFROM %s\nWHERE `%s`>@prevCommitTimestamp\nORDER BY `%s`", "`Foo`", "LastModified", "LastModified")).bind("prevCommitTimestamp").to(Timestamp.MIN_VALUE)).build();
    public static final int SELECT_FOO_ROW_COUNT = 10;
    public static final Statement SELECT_FOO_WITH_SHARDING_PER_DAY_STATEMENT = ((Statement.Builder)Statement.newBuilder((String)(String.format("SELECT *\nFROM %s\nWHERE `%s`>@prevCommitTimestamp", "`Foo`", "LastModified") + " AND `ShardId` IN (" + String.format("TO_BASE64(SHA512(FORMAT_TIMESTAMP('%s', CURRENT_TIMESTAMP(), 'UTC')))", TimebasedShardProvider.Interval.DAY.getDateFormat()) + ", " + String.format("TO_BASE64(SHA512(FORMAT_TIMESTAMP('%s', TIMESTAMP_SUB(CURRENT_TIMESTAMP(), INTERVAL %d SECOND), 'UTC')))", TimebasedShardProvider.Interval.DAY.getDateFormat(), 60) + ")" + String.format("\nORDER BY `%s`", "LastModified"))).bind("prevCommitTimestamp").to(Timestamp.MIN_VALUE)).build();
    public static final int SELECT_FOO_WITH_SHARDING_PER_DAY_ROW_COUNT = 5;
    private static final ResultSet COLUMNS_OPTIONS_FOO_RESULT = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("LastModified").build()).addValues(Value.newBuilder().setStringValue("allow_commit_timestamp").build()).addValues(Value.newBuilder().setStringValue("TRUE").build()).build()).setMetadata(COLUMNS_OPTIONS_METADATA).build();
    private static final Statement COLUMN_OPTIONS_BAR_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT COLUMN_NAME, OPTION_NAME, OPTION_VALUE\nFROM INFORMATION_SCHEMA.COLUMN_OPTIONS\nWHERE TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME = @table").bind("catalog").to("")).bind("schema").to("")).bind("table").to("Bar")).build();
    public static final Statement SELECT_BAR_STATEMENT = ((Statement.Builder)Statement.newBuilder((String)String.format("SELECT *\nFROM %s\nWHERE `%s`>@prevCommitTimestamp\nORDER BY `%s`", "`Bar`", "LastModified", "LastModified")).bind("prevCommitTimestamp").to(Timestamp.MIN_VALUE)).build();
    public static final int SELECT_BAR_ROW_COUNT = 20;
    private static final ResultSet COLUMNS_OPTIONS_BAR_RESULT = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("LastModified").build()).addValues(Value.newBuilder().setStringValue("allow_commit_timestamp").build()).addValues(Value.newBuilder().setStringValue("TRUE").build()).build()).setMetadata(COLUMNS_OPTIONS_METADATA).build();
    private static final Statement COLUMN_OPTIONS_NON_EXISTING_TABLE_STATEMENT = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT COLUMN_NAME, OPTION_NAME, OPTION_VALUE\nFROM INFORMATION_SCHEMA.COLUMN_OPTIONS\nWHERE TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME = @table").bind("catalog").to("")).bind("schema").to("")).bind("table").to("NonExistingTable")).build();
    private static final ResultSet COLUMNS_OPTIONS_NON_EXISTING_TABLE_RESULT = ResultSet.newBuilder().setMetadata(COLUMNS_OPTIONS_METADATA).build();
    protected static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    private Spanner spanner;
    private Statement currentFooPollStatement;
    private Statement currentFooWithShardingPollStatement;
    private Statement currentBarPollStatement;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).build().start();
    }

    @AfterClass
    public static void stopServer() throws Exception {
        server.shutdown();
        server.awaitTermination();
    }

    @After
    public void reset() {
        this.spanner.close();
        mockSpanner.reset();
    }

    @Before
    public void setupResults() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)FIND_LAST_SEEN_COMMIT_TIMESTAMPS_TABLE_STATEMENT, (ResultSet)FIND_LAST_SEEN_COMMIT_TIMESTAMPS_TABLE_RESULTS));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)FIND_LAST_SEEN_COMMIT_TIMESTAMPS_COLUMNS_STATEMENT, (ResultSet)FIND_LAST_SEEN_COMMIT_TIMESTAMPS_COLUMNS_RESULTS));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)FIND_LAST_SEEN_COMMIT_TIMESTAMPS_PK_STATEMENT, (ResultSet)FIND_LAST_SEEN_COMMIT_TIMESTAMPS_PK_RESULTS));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)GET_LAST_COMMIT_TIMESTAMP_STATEMENT, (ResultSet)GET_LAST_SEEN_COMMIT_TIMESTAMP_RESULTS));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)FIND_ALL_TABLES_STATEMENT, (ResultSet)FIND_ALL_TABLES_RESULT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)FIND_ALL_TABLES_EXCEPT_FOO_AND_BAR_STATEMENT, (ResultSet)FIND_ALL_TABLES_EXCEPT_FOO_AND_BAR_RESULT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)FIND_FOO_BAR_NON_EXISTING_TABLE_TABLES_STATEMENT, (ResultSet)FIND_ALL_TABLES_RESULT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)FIND_NON_EXISTING_TABLE_TABLES_STATEMENT, (ResultSet)FIND_NON_EXISTING_TABLE_RESULT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)COLUMN_OPTIONS_FOO_STATEMENT, (ResultSet)COLUMNS_OPTIONS_FOO_RESULT));
        ResultSet fooResults = new RandomResultSetGenerator(10).generate();
        Timestamp maxFooCommitTimestamp = RandomResultSetGenerator.getMaxCommitTimestamp(fooResults);
        this.currentFooPollStatement = ((Statement.Builder)SELECT_FOO_STATEMENT.toBuilder().bind("prevCommitTimestamp").to(maxFooCommitTimestamp)).build();
        mockSpanner.putStatementResults(new MockSpannerServiceImpl.StatementResult[]{MockSpannerServiceImpl.StatementResult.query((Statement)SELECT_FOO_STATEMENT, (ResultSet)fooResults), MockSpannerServiceImpl.StatementResult.query((Statement)this.currentFooPollStatement, (ResultSet)new RandomResultSetGenerator(0).generate())});
        ResultSet fooWithShardingResults = new RandomResultSetGenerator(5).generate();
        Timestamp maxFooWithShardingCommitTimestamp = RandomResultSetGenerator.getMaxCommitTimestamp(fooWithShardingResults);
        this.currentFooWithShardingPollStatement = ((Statement.Builder)SELECT_FOO_WITH_SHARDING_PER_DAY_STATEMENT.toBuilder().bind("prevCommitTimestamp").to(maxFooWithShardingCommitTimestamp)).build();
        mockSpanner.putStatementResults(new MockSpannerServiceImpl.StatementResult[]{MockSpannerServiceImpl.StatementResult.query((Statement)SELECT_FOO_WITH_SHARDING_PER_DAY_STATEMENT, (ResultSet)fooWithShardingResults), MockSpannerServiceImpl.StatementResult.query((Statement)this.currentFooWithShardingPollStatement, (ResultSet)new RandomResultSetGenerator(0).generate())});
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)COLUMN_OPTIONS_BAR_STATEMENT, (ResultSet)COLUMNS_OPTIONS_BAR_RESULT));
        ResultSet barResults = new RandomResultSetGenerator(20).generate();
        Timestamp maxBarCommitTimestamp = RandomResultSetGenerator.getMaxCommitTimestamp(barResults);
        this.currentBarPollStatement = ((Statement.Builder)SELECT_BAR_STATEMENT.toBuilder().bind("prevCommitTimestamp").to(maxBarCommitTimestamp)).build();
        mockSpanner.putStatementResults(new MockSpannerServiceImpl.StatementResult[]{MockSpannerServiceImpl.StatementResult.query((Statement)SELECT_BAR_STATEMENT, (ResultSet)barResults), MockSpannerServiceImpl.StatementResult.query((Statement)this.currentBarPollStatement, (ResultSet)new RandomResultSetGenerator(0).generate())});
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query((Statement)COLUMN_OPTIONS_NON_EXISTING_TABLE_STATEMENT, (ResultSet)COLUMNS_OPTIONS_NON_EXISTING_TABLE_RESULT));
        this.spanner = AbstractMockServerTest.createSpanner();
    }

    private static Spanner createSpanner() {
        return (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("project-id")).setCredentials((Credentials)NoCredentials.getInstance())).setHost("http://localhost:" + server.getPort()).setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder input) {
                return input.usePlaintext();
            }
        }).build().getService();
    }

    protected Spanner getSpanner() {
        return this.spanner;
    }

    protected Statement getCurrentFooPollStatement() {
        return this.currentFooPollStatement;
    }

    protected Statement getCurrentBarPollStatement() {
        return this.currentBarPollStatement;
    }
}

