/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.client.util.Preconditions;
import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiService;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.watcher.CommitTimestampRepository;
import com.google.cloud.spanner.watcher.ShardProvider;
import com.google.cloud.spanner.watcher.SpannerCommitTimestampRepository;
import com.google.cloud.spanner.watcher.SpannerDatabaseChangeWatcher;
import com.google.cloud.spanner.watcher.SpannerTableChangeWatcher;
import com.google.cloud.spanner.watcher.SpannerTableTailer;
import com.google.cloud.spanner.watcher.SpannerUtils;
import com.google.cloud.spanner.watcher.TableId;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class SpannerDatabaseTailer
extends AbstractApiService
implements SpannerDatabaseChangeWatcher {
    private static final Logger logger = Logger.getLogger(SpannerDatabaseTailer.class.getName());
    static final String LIST_TABLE_NAMES_STATEMENT = "SELECT TABLE_NAME\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_NAME NOT IN UNNEST(@excluded)\nAND (@allTables=TRUE OR TABLE_NAME IN UNNEST(@included))\nAND TABLE_CATALOG = @catalog\nAND TABLE_SCHEMA = @schema\nAND TABLE_NAME IN (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.COLUMN_OPTIONS WHERE OPTION_NAME='allow_commit_timestamp' AND OPTION_VALUE='TRUE')";
    private final Object lock = new Object();
    private final Spanner spanner;
    private final DatabaseId databaseId;
    private final String catalog;
    private final String schema;
    private final ShardProvider shardProvider;
    private final Map<TableId, ShardProvider> shardProviders;
    private final boolean allTables;
    private final ImmutableList<String> includedTables;
    private final ImmutableList<String> excludedTables;
    private final CommitTimestampRepository commitTimestampRepository;
    private final Duration pollInterval;
    private final ScheduledExecutorService executor;
    private final boolean isOwnedExecutor;
    private final java.util.function.Function<TableId, String> commitTimestampColumnFunction;
    private ImmutableList<TableId> tables;
    private Map<TableId, SpannerTableChangeWatcher> watchers;
    private final List<SpannerTableChangeWatcher.RowChangeCallback> callbacks = new LinkedList<SpannerTableChangeWatcher.RowChangeCallback>();

    public static TableSelecter newBuilder(Spanner spanner, DatabaseId databaseId) {
        return new BuilderImpl(spanner, databaseId);
    }

    private SpannerDatabaseTailer(BuilderImpl builder) {
        this.spanner = builder.spanner;
        this.databaseId = builder.databaseId;
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.shardProvider = builder.shardProvider;
        this.shardProviders = builder.shardProviders;
        this.allTables = builder.allTables;
        this.includedTables = ImmutableList.copyOf((Collection)builder.includedTables);
        this.excludedTables = ImmutableList.copyOf((Collection)builder.excludedTables);
        this.commitTimestampRepository = builder.commitTimestampRepository;
        this.pollInterval = builder.pollInterval;
        if (builder.executor == null) {
            this.isOwnedExecutor = true;
            this.executor = new ScheduledThreadPoolExecutor(1);
        } else {
            this.isOwnedExecutor = false;
            this.executor = builder.executor;
        }
        this.commitTimestampColumnFunction = builder.commitTimestampColumnFunction;
    }

    private ImmutableList<TableId> findTableNames(DatabaseClient client) {
        Statement statement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)LIST_TABLE_NAMES_STATEMENT).bind("excluded").toStringArray(this.excludedTables)).bind("allTables").to(this.allTables)).bind("included").toStringArray(this.includedTables)).bind("schema").to(this.schema)).bind("catalog").to(this.catalog)).build();
        ImmutableList tables = client.singleUse().executeQueryAsync(statement, new Options.QueryOption[0]).toList((Function)new Function<StructReader, TableId>(){

            public TableId apply(StructReader input) {
                return TableId.newBuilder(SpannerDatabaseTailer.this.databaseId, input.getString(0)).setCatalog(SpannerDatabaseTailer.this.catalog).setSchema(SpannerDatabaseTailer.this.schema).build();
            }
        });
        for (String includedTable : this.includedTables) {
            if (tables.contains((Object)TableId.newBuilder(this.databaseId, includedTable).setCatalog(this.catalog).setSchema(this.schema).build())) continue;
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("Table `%s` was explicitly included for this SpannerDatabaseTailer, but either the table was not found or it does not contain a column with the option allow_commit_timestamp=true.", includedTable));
        }
        return tables;
    }

    @Override
    public void addCallback(SpannerTableChangeWatcher.RowChangeCallback callback) {
        Preconditions.checkState((this.state() == ApiService.State.NEW ? 1 : 0) != 0);
        this.callbacks.add(callback);
    }

    protected void doStart() {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ImmutableList<TableId> tables = SpannerDatabaseTailer.this.getTables();
                    if (tables.isEmpty()) {
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)String.format("No suitable tables found for watcher for database %s", SpannerDatabaseTailer.this.databaseId));
                    }
                    if (SpannerDatabaseTailer.this.isOwnedExecutor) {
                        ((ScheduledThreadPoolExecutor)SpannerDatabaseTailer.this.executor).setCorePoolSize(tables.size());
                    }
                    Object object = SpannerDatabaseTailer.this.lock;
                    synchronized (object) {
                        if (SpannerDatabaseTailer.this.watchers == null) {
                            SpannerDatabaseTailer.this.initWatchersLocked();
                        }
                        for (SpannerTableChangeWatcher watcher : SpannerDatabaseTailer.this.watchers.values()) {
                            watcher.startAsync();
                        }
                    }
                }
                catch (Throwable t) {
                    logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Failed to start watcher for database {0}", (Object)SpannerDatabaseTailer.this.databaseId, t));
                    SpannerDatabaseTailer.this.notifyFailed(t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Object object = this.lock;
        synchronized (object) {
            for (SpannerTableChangeWatcher c : this.watchers.values()) {
                c.stopAsync();
            }
        }
    }

    @Override
    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<TableId> getTables() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tables == null) {
                this.tables = this.findTableNames(this.spanner.getDatabaseClient(this.databaseId));
            }
            return this.tables;
        }
    }

    private void initWatchersLocked() {
        this.watchers = new HashMap<TableId, SpannerTableChangeWatcher>(this.tables.size());
        for (TableId table : this.tables) {
            ShardProvider tableShardProvider = null;
            if (this.shardProviders != null) {
                tableShardProvider = this.shardProviders.get(table);
            }
            if (tableShardProvider == null) {
                tableShardProvider = this.shardProvider;
            }
            SpannerTableTailer watcher = SpannerTableTailer.newBuilder(this.spanner, table).setCommitTimestampRepository(this.commitTimestampRepository).setShardProvider(tableShardProvider).setPollInterval(this.pollInterval).setExecutor(this.executor).setCommitTimestampColumn(this.commitTimestampColumnFunction == null ? null : this.commitTimestampColumnFunction.apply(table)).build();
            for (SpannerTableChangeWatcher.RowChangeCallback callback : this.callbacks) {
                watcher.addCallback(callback);
            }
            watcher.addListener(new ApiService.Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(ApiService.State from, Throwable failure) {
                    Object object = SpannerDatabaseTailer.this.lock;
                    synchronized (object) {
                        for (SpannerTableChangeWatcher c : SpannerDatabaseTailer.this.watchers.values()) {
                            if (c.state() == ApiService.State.FAILED) continue;
                            c.stopAsync();
                        }
                        for (SpannerTableChangeWatcher c : SpannerDatabaseTailer.this.watchers.values()) {
                            if (c.state() != ApiService.State.STOPPING) continue;
                            c.awaitTerminated();
                        }
                        if (SpannerDatabaseTailer.this.isOwnedExecutor) {
                            SpannerDatabaseTailer.this.executor.shutdown();
                        }
                        logger.log(SpannerUtils.LogRecordBuilder.of(Level.WARNING, "Watcher failed to start for database {0}", (Object)SpannerDatabaseTailer.this.databaseId, failure));
                        SpannerDatabaseTailer.this.notifyFailed(failure);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void running() {
                    Object object = SpannerDatabaseTailer.this.lock;
                    synchronized (object) {
                        if (SpannerDatabaseTailer.this.state() == ApiService.State.RUNNING) {
                            return;
                        }
                        for (SpannerTableChangeWatcher c : SpannerDatabaseTailer.this.watchers.values()) {
                            if (c.state() == ApiService.State.RUNNING) continue;
                            return;
                        }
                        logger.log(Level.INFO, "Watcher started successfully for database {0}", SpannerDatabaseTailer.this.databaseId);
                        SpannerDatabaseTailer.this.notifyStarted();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void terminated(ApiService.State from) {
                    Object object = SpannerDatabaseTailer.this.lock;
                    synchronized (object) {
                        if (SpannerDatabaseTailer.this.state() == ApiService.State.TERMINATED) {
                            return;
                        }
                        for (SpannerTableChangeWatcher c : SpannerDatabaseTailer.this.watchers.values()) {
                            if (c.state() == ApiService.State.TERMINATED) continue;
                            return;
                        }
                        if (SpannerDatabaseTailer.this.isOwnedExecutor) {
                            SpannerDatabaseTailer.this.executor.shutdown();
                        }
                        logger.log(Level.INFO, "Watcher terminated for database {0}", SpannerDatabaseTailer.this.databaseId);
                        SpannerDatabaseTailer.this.notifyStopped();
                    }
                }
            }, MoreExecutors.directExecutor());
            this.watchers.put(table, watcher);
        }
    }

    static class BuilderImpl
    implements TableSelecter,
    TableExcluder,
    Builder {
        private final Spanner spanner;
        private final DatabaseId databaseId;
        private String catalog = "";
        private String schema = "";
        private ShardProvider shardProvider;
        private Map<TableId, ShardProvider> shardProviders;
        private boolean allTables = false;
        private List<String> includedTables = new ArrayList<String>();
        private List<String> excludedTables = new ArrayList<String>();
        private CommitTimestampRepository commitTimestampRepository;
        private Duration pollInterval = Duration.ofSeconds((long)1L);
        private ScheduledExecutorService executor;
        private java.util.function.Function<TableId, String> commitTimestampColumnFunction;

        private BuilderImpl(Spanner spanner, DatabaseId databaseId) {
            this.spanner = (Spanner)Preconditions.checkNotNull((Object)spanner);
            this.databaseId = (DatabaseId)Preconditions.checkNotNull((Object)databaseId);
            this.commitTimestampRepository = SpannerCommitTimestampRepository.newBuilder(spanner, databaseId).build();
        }

        @Override
        public TableExcluder allTables() {
            Preconditions.checkState((boolean)this.includedTables.isEmpty(), (Object)"Cannot include specific tables in combination with allTables");
            this.allTables = true;
            return this;
        }

        @Override
        public Builder includeTables(String firstTable, String ... otherTables) {
            Preconditions.checkNotNull((Object)firstTable);
            Preconditions.checkState((!this.allTables ? 1 : 0) != 0, (Object)"Cannot include specific tables in combination with allTables");
            this.includedTables.add(firstTable);
            this.includedTables.addAll(Arrays.asList(otherTables));
            return this;
        }

        @Override
        public Builder except(String ... excludedTables) {
            this.excludedTables.addAll(Arrays.asList(excludedTables));
            return this;
        }

        @Override
        public Builder setCommitTimestampRepository(CommitTimestampRepository repository) {
            this.commitTimestampRepository = (CommitTimestampRepository)Preconditions.checkNotNull((Object)repository);
            return this;
        }

        @Override
        public Builder setShardProvider(ShardProvider shardProvider) {
            this.shardProvider = shardProvider;
            return this;
        }

        @Override
        public Builder setShardProviders(Map<TableId, ShardProvider> shardProviders) {
            this.shardProviders = shardProviders;
            return this;
        }

        @Override
        public Builder setPollInterval(Duration interval) {
            this.pollInterval = (Duration)Preconditions.checkNotNull((Object)interval);
            return this;
        }

        @Override
        public Builder setExecutor(ScheduledExecutorService executor) {
            this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
            return this;
        }

        @Override
        public Builder setCommitTimestampColumnFunction(java.util.function.Function<TableId, String> commitTimestampColumnFunction) {
            this.commitTimestampColumnFunction = commitTimestampColumnFunction;
            return this;
        }

        @Override
        public SpannerDatabaseTailer build() {
            return new SpannerDatabaseTailer(this);
        }
    }

    public static interface TableExcluder
    extends Builder {
        public Builder except(String ... var1);
    }

    public static interface TableSelecter {
        public Builder includeTables(String var1, String ... var2);

        public TableExcluder allTables();
    }

    public static interface Builder {
        public Builder setCommitTimestampRepository(CommitTimestampRepository var1);

        public Builder setShardProvider(ShardProvider var1);

        public Builder setShardProviders(Map<TableId, ShardProvider> var1);

        public Builder setPollInterval(Duration var1);

        public Builder setExecutor(ScheduledExecutorService var1);

        public Builder setCommitTimestampColumnFunction(java.util.function.Function<TableId, String> var1);

        public SpannerDatabaseTailer build();
    }
}

