/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.watcher.ShardProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

public final class FixedShardProvider
implements ShardProvider {
    private final Value value;
    private final String sqlAppendment;
    private static final ImmutableSet<Type.Code> SUPPORTED_TYPES = ImmutableSet.of((Object)Type.Code.BOOL, (Object)Type.Code.BYTES, (Object)Type.Code.DATE, (Object)Type.Code.FLOAT64, (Object)Type.Code.INT64, (Object)Type.Code.STRING, (Object[])new Type.Code[]{Type.Code.TIMESTAMP});

    public static FixedShardProvider create(String column, boolean value) {
        return new FixedShardProvider(column, Value.bool((boolean)value));
    }

    public static FixedShardProvider create(String column, ByteArray value) {
        return new FixedShardProvider(column, Value.bytes((ByteArray)value));
    }

    public static FixedShardProvider create(String column, Date value) {
        return new FixedShardProvider(column, Value.date((Date)value));
    }

    public static FixedShardProvider create(String column, double value) {
        return new FixedShardProvider(column, Value.float64((double)value));
    }

    public static FixedShardProvider create(String column, long value) {
        return new FixedShardProvider(column, Value.int64((long)value));
    }

    public static FixedShardProvider create(String column, String value) {
        return new FixedShardProvider(column, Value.string((String)value));
    }

    public static FixedShardProvider create(String column, Timestamp value) {
        return new FixedShardProvider(column, Value.timestamp((Timestamp)value));
    }

    public static FixedShardProvider create(String column, Value value) {
        return new FixedShardProvider(column, value);
    }

    private FixedShardProvider(String column, Value value) {
        Preconditions.checkNotNull((Object)column);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains((Object)value.getType().getCode()));
        this.value = value;
        this.sqlAppendment = String.format(" AND `%s`=@shard", column);
    }

    @Override
    public void appendShardFilter(Statement.Builder statementBuilder) {
        statementBuilder.append(this.sqlAppendment);
        statementBuilder.bind("shard").to(this.value);
    }

    @Override
    public Value getShardValue() {
        return this.value;
    }
}

