/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockFile
implements Closeable {
    private static final ConcurrentHashMap<Path, Lock> lockMap = new ConcurrentHashMap();
    private final Path lockFilePath;
    private final FileLock fileLock;
    private final OutputStream outputStream;

    private LockFile(Path lockFilePath, FileLock fileLock, OutputStream outputStream) {
        this.lockFilePath = lockFilePath;
        this.fileLock = fileLock;
        this.outputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockFile lock(Path lockFile) throws IOException {
        try {
            lockMap.computeIfAbsent(lockFile, key -> new ReentrantLock()).lockInterruptibly();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while trying to acquire lock", ex);
        }
        Files.createDirectories(lockFile.getParent(), new FileAttribute[0]);
        FileOutputStream outputStream = new FileOutputStream(lockFile.toFile());
        FileLock fileLock = null;
        try {
            fileLock = outputStream.getChannel().lock();
            LockFile lockFile2 = new LockFile(lockFile, fileLock, outputStream);
            return lockFile2;
        }
        finally {
            if (fileLock == null) {
                outputStream.close();
            }
        }
    }

    @Override
    public void close() {
        try {
            this.fileLock.release();
            this.outputStream.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to release lock", ex);
        }
        finally {
            ((Lock)Preconditions.checkNotNull((Object)lockMap.get(this.lockFilePath))).unlock();
        }
    }
}

