/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.ModificationTimeProvider;
import com.google.cloud.tools.jib.api.buildplan.RelativeUnixPath;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class JavaContainerBuilderHelper {
    public static FileEntriesLayer extraDirectoryLayerConfiguration(Path sourceDirectory, AbsoluteUnixPath targetDirectory, Map<String, FilePermissions> extraDirectoryPermissions, ModificationTimeProvider modificationTimeProvider) throws IOException {
        FileEntriesLayer.Builder builder = FileEntriesLayer.builder().setName(JavaContainerBuilder.LayerType.EXTRA_FILES.getName());
        LinkedHashMap<PathMatcher, FilePermissions> pathMatchers = new LinkedHashMap<PathMatcher, FilePermissions>();
        for (Map.Entry<String, FilePermissions> entry : extraDirectoryPermissions.entrySet()) {
            pathMatchers.put(FileSystems.getDefault().getPathMatcher("glob:" + entry.getKey()), entry.getValue());
        }
        new DirectoryWalker(sourceDirectory).filterRoot().walk(localPath -> {
            AbsoluteUnixPath pathOnContainer = targetDirectory.resolve(sourceDirectory.relativize(localPath));
            Instant modificationTime = modificationTimeProvider.get(localPath, pathOnContainer);
            FilePermissions permissions = (FilePermissions)extraDirectoryPermissions.get(pathOnContainer.toString());
            if (permissions == null) {
                Path containerPath = Paths.get(pathOnContainer.toString(), new String[0]);
                for (Map.Entry entry : pathMatchers.entrySet()) {
                    if (!((PathMatcher)entry.getKey()).matches(containerPath)) continue;
                    builder.addEntry(localPath, pathOnContainer, (FilePermissions)entry.getValue(), modificationTime);
                    return;
                }
                builder.addEntry(localPath, pathOnContainer, modificationTime);
            } else {
                builder.addEntry(localPath, pathOnContainer, permissions, modificationTime);
            }
        });
        return builder.build();
    }

    public static JibContainerBuilder fromExplodedWar(JavaContainerBuilder javaContainerBuilder, Path explodedWar, Set<String> projectArtifactFilename) throws IOException {
        Path webInfLib = explodedWar.resolve("WEB-INF/lib");
        Path webInfClasses = explodedWar.resolve("WEB-INF/classes");
        Predicate<Path> isDependency = path -> path.startsWith(webInfLib);
        Predicate<Path> isClassFile = path -> path.startsWith(webInfClasses) && path.getFileName().toString().endsWith(".class");
        Predicate<Path> isResource = isDependency.or(isClassFile).negate();
        Predicate<Path> isSnapshot = path -> path.getFileName().toString().contains("SNAPSHOT");
        Predicate<Path> isProjectDependency = path -> projectArtifactFilename.contains(path.getFileName().toString());
        javaContainerBuilder.setResourcesDestination(RelativeUnixPath.get((String)"")).setClassesDestination(RelativeUnixPath.get((String)"WEB-INF/classes")).setDependenciesDestination(RelativeUnixPath.get((String)"WEB-INF/lib"));
        if (Files.exists(explodedWar, new LinkOption[0])) {
            javaContainerBuilder.addResources(explodedWar, isResource);
        }
        if (Files.exists(webInfClasses, new LinkOption[0])) {
            javaContainerBuilder.addClasses(webInfClasses, isClassFile);
        }
        if (Files.exists(webInfLib, new LinkOption[0])) {
            javaContainerBuilder.addDependencies((List<Path>)new DirectoryWalker(webInfLib).filterRoot().filter(isSnapshot.negate()).filter(isProjectDependency.negate()).walk());
            javaContainerBuilder.addSnapshotDependencies((List<Path>)new DirectoryWalker(webInfLib).filterRoot().filter(isSnapshot).walk());
            javaContainerBuilder.addProjectDependencies((List<Path>)new DirectoryWalker(webInfLib).filterRoot().filter(isProjectDependency).walk());
        }
        return javaContainerBuilder.toContainerBuilder();
    }

    private JavaContainerBuilderHelper() {
    }
}

