/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionChecker<V extends Comparable<? super V>> {
    private static final String VERSION_REGEX = "\\d+(\\.\\d+(\\.\\d+)?)?";
    private static final String INTERVAL_REGEX = "[\\[(](?<left>\\d+(\\.\\d+(\\.\\d+)?)?)?,(?<right>\\d+(\\.\\d+(\\.\\d+)?)?)?[])]";
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("[\\[(](?<left>\\d+(\\.\\d+(\\.\\d+)?)?)?,(?<right>\\d+(\\.\\d+(\\.\\d+)?)?)?[])]");
    private Function<String, V> converter;

    @VisibleForTesting
    static <T extends Comparable<? super T>> boolean LT(T a, T b) {
        return a.compareTo(b) < 0;
    }

    @VisibleForTesting
    static <T extends Comparable<? super T>> boolean LE(T a, T b) {
        return a.compareTo(b) <= 0;
    }

    @VisibleForTesting
    static <T extends Comparable<? super T>> boolean GT(T a, T b) {
        return a.compareTo(b) > 0;
    }

    @VisibleForTesting
    static <T extends Comparable<? super T>> boolean GE(T a, T b) {
        return a.compareTo(b) >= 0;
    }

    public VersionChecker(Function<String, V> converter) {
        this.converter = converter;
    }

    @VisibleForTesting
    public boolean compatibleVersion(String acceptableVersionRange, String actualVersion) {
        BiPredicate<Comparable, Comparable> rightComparator;
        V pluginVersion = this.parseVersion(actualVersion);
        if (acceptableVersionRange.matches(VERSION_REGEX)) {
            return VersionChecker.GE(pluginVersion, this.parseVersion(acceptableVersionRange));
        }
        Matcher matcher = INTERVAL_PATTERN.matcher(acceptableVersionRange);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"invalid version range");
        String leftBound = matcher.group("left");
        String rightBound = matcher.group("right");
        Preconditions.checkArgument((leftBound != null || rightBound != null ? 1 : 0) != 0, (Object)"left and right bounds cannot both be empty");
        BiPredicate<Comparable, Comparable> leftComparator = acceptableVersionRange.startsWith("[") ? VersionChecker::GE : VersionChecker::GT;
        BiPredicate<Comparable, Comparable> biPredicate = rightComparator = acceptableVersionRange.endsWith("]") ? VersionChecker::LE : VersionChecker::LT;
        if (leftBound != null && !leftComparator.test((Comparable)pluginVersion, (Comparable)this.parseVersion(leftBound))) {
            return false;
        }
        return rightBound == null || rightComparator.test((Comparable)pluginVersion, (Comparable)this.parseVersion(rightBound));
    }

    private V parseVersion(String versionString) {
        try {
            return (V)((Comparable)this.converter.apply(versionString));
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("unable to parse '" + versionString + "'", ex);
        }
    }
}

