/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.skaffold.SkaffoldBindingMojo;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;

@Mojo(name="_skaffold-files", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class FilesMojo
extends SkaffoldBindingMojo {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-files";
    @Nullable
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Nullable
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Nullable
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Deprecated
    @Parameter
    private JibPluginConfiguration.ExtraDirectoryParameters extraDirectory = new JibPluginConfiguration.ExtraDirectoryParameters();
    @Parameter
    private JibPluginConfiguration.ExtraDirectoriesParameters extraDirectories = new JibPluginConfiguration.ExtraDirectoriesParameters();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Preconditions.checkNotNull((Object)this.project);
        Preconditions.checkNotNull(this.projects);
        Preconditions.checkNotNull((Object)this.session);
        Preconditions.checkNotNull((Object)this.projectDependenciesResolver);
        this.checkJibVersion();
        System.out.println(this.project.getFile());
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        System.out.println(this.project.getBuild().getSourceDirectory());
        ImmutableSet.copyOf((Collection)this.project.getBuild().getResources()).stream().map(FileSet::getDirectory).forEach(System.out::println);
        if (this.project.getPlugin("com.google.cloud.tools:jib-maven-plugin") != null) {
            this.resolveExtraDirectories().stream().forEach(System.out::println);
        }
        Set projectArtifacts = this.projects.stream().map(MavenProject::getArtifact).map(Object::toString).collect(Collectors.toSet());
        DependencyFilter ignoreProjectDependenciesFilter = (node, parents) -> {
            if (node == null || node.getDependency() == null) {
                return false;
            }
            if (projectArtifacts.contains(node.getArtifact().toString())) {
                return false;
            }
            return "compile+runtime".contains(node.getDependency().getScope());
        };
        try {
            DependencyResolutionResult resolutionResult = this.projectDependenciesResolver.resolve(new DefaultDependencyResolutionRequest(this.project, this.session.getRepositorySession()).setResolutionFilter(ignoreProjectDependenciesFilter));
            resolutionResult.getDependencies().stream().map(Dependency::getArtifact).filter(Artifact::isSnapshot).map(Artifact::getFile).forEach(System.out::println);
        }
        catch (DependencyResolutionException ex) {
            throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)ex));
        }
    }

    private List<Path> resolveExtraDirectories() throws MojoExecutionException {
        List<File> paths;
        String property;
        String deprecatedProperty = MavenProjectProperties.getProperty("jib.extraDirectory.path", this.project, this.session);
        String newProperty = MavenProjectProperties.getProperty("jib.extraDirectories.paths", this.project, this.session);
        List<File> deprecatedPaths = this.extraDirectory.getPaths();
        List<File> newPaths = this.extraDirectories.getPaths();
        if (deprecatedProperty != null && newProperty != null) {
            throw new MojoExecutionException("You cannot configure both 'jib.extraDirectory.path' and 'jib.extraDirectories.paths'");
        }
        if (!deprecatedPaths.isEmpty() && !newPaths.isEmpty()) {
            throw new MojoExecutionException("You cannot configure both <extraDirectory> and <extraDirectories>");
        }
        String string = property = newProperty != null ? newProperty : deprecatedProperty;
        if (property != null) {
            List<String> paths2 = ConfigurationPropertyValidator.parseListProperty(property);
            return paths2.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toList());
        }
        List<File> list = paths = !newPaths.isEmpty() ? newPaths : deprecatedPaths;
        if (paths.isEmpty()) {
            Path projectBase = ((MavenProject)Preconditions.checkNotNull((Object)this.project)).getBasedir().getAbsoluteFile().toPath();
            Path srcMainJib = Paths.get("src", "main", "jib");
            return Collections.singletonList(projectBase.resolve(srcMainJib));
        }
        return paths.stream().map(File::getAbsoluteFile).map(File::toPath).collect(Collectors.toList());
    }
}

