/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.ExtractTarStep;
import com.google.cloud.tools.jib.builder.steps.LoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.ObtainBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayerStep;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.builder.steps.SaveDockerStep;
import com.google.cloud.tools.jib.builder.steps.WriteTarFileStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Image;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StepsRunner {
    private final StepResults results = new StepResults();
    private final ExecutorService executorService;
    private final BuildConfiguration buildConfiguration;
    private final List<Runnable> stepsToRun = new ArrayList<Runnable>();
    @Nullable
    private String rootProgressDescription;
    @Nullable
    private ProgressEventDispatcher rootProgressDispatcher;

    public static StepsRunner begin(BuildConfiguration buildConfiguration) {
        Object executorService = JibSystemProperties.serializeExecution() ? MoreExecutors.newDirectExecutorService() : buildConfiguration.getExecutorService();
        return new StepsRunner(MoreExecutors.listeningDecorator((ExecutorService)executorService), buildConfiguration);
    }

    private static <E> List<E> realizeFutures(List<Future<E>> futures) throws InterruptedException, ExecutionException {
        ArrayList<E> values = new ArrayList<E>();
        for (Future<E> future : futures) {
            values.add(future.get());
        }
        return values;
    }

    private StepsRunner(ListeningExecutorService executorService, BuildConfiguration buildConfiguration) {
        this.executorService = executorService;
        this.buildConfiguration = buildConfiguration;
    }

    public StepsRunner dockerLoadSteps(DockerClient dockerClient) {
        this.rootProgressDescription = "building image to Docker daemon";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImage);
        this.stepsToRun.add(() -> this.loadDocker(dockerClient));
        return this;
    }

    public StepsRunner tarBuildSteps(Path outputPath) {
        this.rootProgressDescription = "building image to tar file";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImage);
        this.stepsToRun.add(() -> this.writeTarFile(outputPath));
        return this;
    }

    public StepsRunner registryPushSteps() {
        this.rootProgressDescription = "building image to registry";
        boolean layersRequiredLocally = JibSystemProperties.alwaysCacheBaseImage();
        this.stepsToRun.add(this::retrieveTargetRegistryCredentials);
        this.stepsToRun.add(this::authenticatePush);
        this.addRetrievalSteps(layersRequiredLocally);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImage);
        this.stepsToRun.add(this::pushBaseImageLayers);
        this.stepsToRun.add(this::pushApplicationLayers);
        this.stepsToRun.add(this::pushContainerConfiguration);
        this.stepsToRun.add(this::pushImages);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BuildResult run() throws ExecutionException, InterruptedException {
        Preconditions.checkNotNull((Object)this.rootProgressDescription);
        try (ProgressEventDispatcher progressEventDispatcher = ProgressEventDispatcher.newRoot(this.buildConfiguration.getEventHandlers(), this.rootProgressDescription, this.stepsToRun.size());){
            this.rootProgressDispatcher = progressEventDispatcher;
            this.stepsToRun.forEach(Runnable::run);
            BuildResult buildResult = (BuildResult)this.results.buildResult.get();
            return buildResult;
        }
        catch (ExecutionException ex) {
            ExecutionException unrolled = ex;
            while (unrolled.getCause() instanceof ExecutionException) {
                unrolled = (ExecutionException)unrolled.getCause();
            }
            throw unrolled;
        }
    }

    private void addRetrievalSteps(boolean layersRequiredLocally) {
        ImageConfiguration baseImageConfiguration = this.buildConfiguration.getBaseImageConfiguration();
        if (baseImageConfiguration.getTarPath().isPresent()) {
            this.results.tarPath = (Future)Futures.immediateFuture((Object)baseImageConfiguration.getTarPath().get());
            this.stepsToRun.add(this::extractTar);
        } else if (baseImageConfiguration.getDockerClient().isPresent()) {
            this.stepsToRun.add(this::saveDocker);
            this.stepsToRun.add(this::extractTar);
        } else {
            this.stepsToRun.add(this::pullBaseImage);
            this.stepsToRun.add(() -> this.obtainBaseImageLayers(layersRequiredLocally));
        }
    }

    private void retrieveTargetRegistryCredentials() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.targetRegistryCredentials = this.executorService.submit(RetrieveRegistryCredentialsStep.forTargetImage(this.buildConfiguration, childProgressDispatcherFactory));
    }

    private void authenticatePush() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.pushAuthorization = this.executorService.submit(() -> new AuthenticatePushStep(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.targetRegistryCredentials.get()).orElse(null)).call());
    }

    private void saveDocker() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        Optional<DockerClient> dockerClient = this.buildConfiguration.getBaseImageConfiguration().getDockerClient();
        Preconditions.checkArgument((boolean)dockerClient.isPresent());
        this.results.tarPath = this.executorService.submit(new SaveDockerStep(this.buildConfiguration, dockerClient.get(), childProgressDispatcherFactory));
    }

    private void extractTar() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        Future<ExtractTarStep.LocalImage> localImageFuture = this.executorService.submit(() -> new ExtractTarStep(this.buildConfiguration, (Path)this.results.tarPath.get(), childProgressDispatcherFactory).call());
        this.results.baseImageAndAuth = this.executorService.submit(() -> new PullBaseImageStep.ImageAndAuthorization(((ExtractTarStep.LocalImage)localImageFuture.get()).baseImage, null));
        this.results.baseImageLayers = this.executorService.submit(() -> ((ExtractTarStep.LocalImage)localImageFuture.get()).layers.stream().map(Futures::immediateFuture).collect(Collectors.toList()));
    }

    private void pullBaseImage() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImageAndAuth = this.executorService.submit(new PullBaseImageStep(this.buildConfiguration, childProgressDispatcherFactory));
    }

    private void obtainBaseImageLayers(boolean layersRequiredLocally) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImageLayers = this.executorService.submit(() -> this.scheduleCallables(layersRequiredLocally ? ObtainBaseImageLayerStep.makeListForForcedDownload(this.buildConfiguration, childProgressDispatcherFactory, (PullBaseImageStep.ImageAndAuthorization)this.results.baseImageAndAuth.get()) : ObtainBaseImageLayerStep.makeListForSelectiveDownload(this.buildConfiguration, childProgressDispatcherFactory, (PullBaseImageStep.ImageAndAuthorization)this.results.baseImageAndAuth.get(), ((Optional)this.results.pushAuthorization.get()).orElse(null))));
    }

    private void pushBaseImageLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.baseImageLayerPushResults = this.executorService.submit(() -> this.scheduleCallables(PushLayerStep.makeList(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (List)this.results.baseImageLayers.get())));
    }

    private void buildAndCacheApplicationLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.applicationLayers = this.scheduleCallables(BuildAndCacheApplicationLayerStep.makeList(this.buildConfiguration, childProgressDispatcherFactory));
    }

    private void buildImage() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.builtImage = this.executorService.submit(() -> new BuildImageStep(this.buildConfiguration, childProgressDispatcherFactory, ((PullBaseImageStep.ImageAndAuthorization)this.results.baseImageAndAuth.get()).getImage(), StepsRunner.realizeFutures((List)this.results.baseImageLayers.get()), StepsRunner.realizeFutures((List)Verify.verifyNotNull((Object)this.results.applicationLayers))).call());
    }

    private void pushContainerConfiguration() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.containerConfigurationPushResult = this.executorService.submit(() -> new PushContainerConfigurationStep(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (Image)this.results.builtImage.get()).call());
    }

    private void pushApplicationLayers() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.applicationLayerPushResults = this.executorService.submit(() -> this.scheduleCallables(PushLayerStep.makeList(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (List)Verify.verifyNotNull((Object)this.results.applicationLayers))));
    }

    private void pushImages() {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> {
            StepsRunner.realizeFutures((List)this.results.baseImageLayerPushResults.get());
            StepsRunner.realizeFutures((List)this.results.applicationLayerPushResults.get());
            List manifestPushResults = this.scheduleCallables(PushImageStep.makeList(this.buildConfiguration, childProgressDispatcherFactory, ((Optional)this.results.pushAuthorization.get()).orElse(null), (BlobDescriptor)this.results.containerConfigurationPushResult.get(), (Image)this.results.builtImage.get()));
            StepsRunner.realizeFutures(manifestPushResults);
            return (BuildResult)manifestPushResults.get(0).get();
        });
    }

    private void loadDocker(DockerClient dockerClient) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> new LoadDockerStep(this.buildConfiguration, childProgressDispatcherFactory, dockerClient, (Image)this.results.builtImage.get()).call());
    }

    private void writeTarFile(Path outputPath) {
        ProgressEventDispatcher.Factory childProgressDispatcherFactory = ((ProgressEventDispatcher)Verify.verifyNotNull((Object)this.rootProgressDispatcher)).newChildProducer();
        this.results.buildResult = this.executorService.submit(() -> new WriteTarFileStep(this.buildConfiguration, childProgressDispatcherFactory, outputPath, (Image)this.results.builtImage.get()).call());
    }

    private <E> List<Future<E>> scheduleCallables(ImmutableList<? extends Callable<E>> callables) {
        return callables.stream().map(this.executorService::submit).collect(Collectors.toList());
    }

    private static class StepResults {
        private Future<Path> tarPath = StepResults.failedFuture();
        private Future<PullBaseImageStep.ImageAndAuthorization> baseImageAndAuth = StepResults.failedFuture();
        private Future<List<Future<PreparedLayer>>> baseImageLayers = StepResults.failedFuture();
        @Nullable
        private List<Future<PreparedLayer>> applicationLayers;
        private Future<Image> builtImage = StepResults.failedFuture();
        private Future<Optional<Credential>> targetRegistryCredentials = StepResults.failedFuture();
        private Future<Optional<Authorization>> pushAuthorization = StepResults.failedFuture();
        private Future<List<Future<BlobDescriptor>>> baseImageLayerPushResults = StepResults.failedFuture();
        private Future<List<Future<BlobDescriptor>>> applicationLayerPushResults = StepResults.failedFuture();
        private Future<BlobDescriptor> containerConfigurationPushResult = StepResults.failedFuture();
        private Future<BuildResult> buildResult = StepResults.failedFuture();

        private StepResults() {
        }

        private static <E> Future<E> failedFuture() {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("invalid usage; required step not configured"));
        }
    }
}

