/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.event.progress.ThrottledAccumulatingConsumer;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.zip.GZIPOutputStream;

public class ExtractTarStep
implements Callable<LocalImage> {
    private final BuildConfiguration buildConfiguration;
    private final Path tarPath;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;

    @VisibleForTesting
    static boolean isGzipped(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.mark(2);
            int magic = inputStream.read() & 0xFF | inputStream.read() << 8 & 0xFF00;
            boolean bl = magic == 35615;
            return bl;
        }
    }

    ExtractTarStep(BuildConfiguration buildConfiguration, Path tarPath, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        this.buildConfiguration = buildConfiguration;
        this.tarPath = tarPath;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public LocalImage call() throws IOException, LayerCountMismatchException, BadContainerConfigurationFormatException, CacheCorruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CachedLayer getCachedTarLayer(DescriptorDigest diffId, Path layerFile, boolean layersAreCompressed, ProgressEventDispatcher.Factory progressEventDispatcherFactory) throws IOException, CacheCorruptedException {
        Throwable throwable = null;
        try (ProgressEventDispatcher childDispatcher = progressEventDispatcherFactory.create("compressing layer " + diffId, Files.size(layerFile));){
            CachedLayer cachedLayer;
            Cache cache;
            Throwable throwable2;
            ThrottledAccumulatingConsumer throttledProgressReporter;
            block16: {
                block15: {
                    throttledProgressReporter = new ThrottledAccumulatingConsumer(childDispatcher::dispatchProgress);
                    throwable2 = null;
                    cache = this.buildConfiguration.getBaseImageLayersCache();
                    Optional<CachedLayer> optionalLayer = cache.retrieveTarLayer(diffId);
                    if (!optionalLayer.isPresent()) break block15;
                    CachedLayer cachedLayer2 = optionalLayer.get();
                    ExtractTarStep.$closeResource(throwable2, throttledProgressReporter);
                    return cachedLayer2;
                }
                if (!layersAreCompressed) break block16;
                CachedLayer cachedLayer3 = cache.writeTarLayer(diffId, Blobs.from(layerFile));
                ExtractTarStep.$closeResource(throwable2, throttledProgressReporter);
                return cachedLayer3;
            }
            try {
                Blob compressedBlob = Blobs.from(outputStream -> {
                    GZIPOutputStream compressorStream = new GZIPOutputStream(outputStream);
                    Throwable throwable = null;
                    try {
                        NotifyingOutputStream notifyingOutputStream = new NotifyingOutputStream(compressorStream, throttledProgressReporter);
                        Throwable throwable2 = null;
                        try {
                            Blobs.from(layerFile).writeTo(notifyingOutputStream);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            ExtractTarStep.$closeResource(throwable2, notifyingOutputStream);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        ExtractTarStep.$closeResource(throwable, compressorStream);
                    }
                });
                cachedLayer = cache.writeTarLayer(diffId, compressedBlob);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ExtractTarStep.$closeResource(throwable2, throttledProgressReporter);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            ExtractTarStep.$closeResource(throwable2, throttledProgressReporter);
            return cachedLayer;
        }
    }

    static class LocalImage {
        final Image baseImage;
        final List<PreparedLayer> layers;

        LocalImage(Image baseImage, List<PreparedLayer> layers) {
            this.baseImage = baseImage;
            this.layers = layers;
        }
    }
}

