/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static void unzip(Path archive, Path destination) throws IOException {
        String canonicalDestination = destination.toFile().getCanonicalPath();
        try (InputStream fileIn = Files.newInputStream(archive, new OpenOption[0]);
             ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(fileIn));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                Path entryPath = destination.resolve(entry.getName());
                String canonicalTarget = entryPath.toFile().getCanonicalPath();
                if (!canonicalTarget.startsWith(canonicalDestination + File.separator)) {
                    String offender = entry.getName() + " from " + archive;
                    throw new IOException("Blocked unzipping files outside destination: " + offender);
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    try (OutputStream out = Files.newOutputStream(entryPath, new OpenOption[0]);){
                        ByteStreams.copy((InputStream)zipIn, (OutputStream)out);
                    }
                }
                entry = zipIn.getNextEntry();
            }
        }
    }
}

