/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.api.ImageFormat;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.OCIManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class BuildConfiguration {
    private static final Class<? extends BuildableManifestTemplate> DEFAULT_TARGET_FORMAT = V22ManifestTemplate.class;
    private static final String DEFAULT_TOOL_NAME = "jib";
    private final ImageConfiguration baseImageConfiguration;
    private final ImageConfiguration targetImageConfiguration;
    private final ImmutableSet<String> additionalTargetImageTags;
    @Nullable
    private final ContainerConfiguration containerConfiguration;
    private final Cache baseImageLayersCache;
    private final Cache applicationLayersCache;
    private Class<? extends BuildableManifestTemplate> targetFormat;
    private final boolean allowInsecureRegistries;
    private final boolean offline;
    private final ImmutableList<LayerConfiguration> layerConfigurations;
    private final String toolName;
    private final EventHandlers eventHandlers;
    private final ExecutorService executorService;

    public static Builder builder() {
        return new Builder();
    }

    private BuildConfiguration(ImageConfiguration baseImageConfiguration, ImageConfiguration targetImageConfiguration, ImmutableSet<String> additionalTargetImageTags, @Nullable ContainerConfiguration containerConfiguration, Cache baseImageLayersCache, Cache applicationLayersCache, Class<? extends BuildableManifestTemplate> targetFormat, boolean allowInsecureRegistries, boolean offline, ImmutableList<LayerConfiguration> layerConfigurations, String toolName, EventHandlers eventHandlers, ExecutorService executorService) {
        this.baseImageConfiguration = baseImageConfiguration;
        this.targetImageConfiguration = targetImageConfiguration;
        this.additionalTargetImageTags = additionalTargetImageTags;
        this.containerConfiguration = containerConfiguration;
        this.baseImageLayersCache = baseImageLayersCache;
        this.applicationLayersCache = applicationLayersCache;
        this.targetFormat = targetFormat;
        this.allowInsecureRegistries = allowInsecureRegistries;
        this.offline = offline;
        this.layerConfigurations = layerConfigurations;
        this.toolName = toolName;
        this.eventHandlers = eventHandlers;
        this.executorService = executorService;
    }

    public ImageConfiguration getBaseImageConfiguration() {
        return this.baseImageConfiguration;
    }

    public ImageConfiguration getTargetImageConfiguration() {
        return this.targetImageConfiguration;
    }

    public ImmutableSet<String> getAllTargetImageTags() {
        ImmutableSet.Builder allTargetImageTags = ImmutableSet.builderWithExpectedSize((int)(1 + this.additionalTargetImageTags.size()));
        allTargetImageTags.add((Object)this.targetImageConfiguration.getImageTag());
        allTargetImageTags.addAll(this.additionalTargetImageTags);
        return allTargetImageTags.build();
    }

    @Nullable
    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public Class<? extends BuildableManifestTemplate> getTargetFormat() {
        return this.targetFormat;
    }

    public String getToolName() {
        return this.toolName;
    }

    public EventHandlers getEventHandlers() {
        return this.eventHandlers;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Cache getBaseImageLayersCache() {
        return this.baseImageLayersCache;
    }

    public Cache getApplicationLayersCache() {
        return this.applicationLayersCache;
    }

    public boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public ImmutableList<LayerConfiguration> getLayerConfigurations() {
        return this.layerConfigurations;
    }

    public RegistryClient.Factory newBaseImageRegistryClientFactory() {
        return this.newRegistryClientFactory(this.baseImageConfiguration);
    }

    public RegistryClient.Factory newTargetImageRegistryClientFactory() {
        return this.newRegistryClientFactory(this.targetImageConfiguration);
    }

    private RegistryClient.Factory newRegistryClientFactory(ImageConfiguration imageConfiguration) {
        return RegistryClient.factory(this.getEventHandlers(), imageConfiguration.getImageRegistry(), imageConfiguration.getImageRepository()).setAllowInsecureRegistries(this.getAllowInsecureRegistries()).setUserAgentSuffix(this.getToolName());
    }

    static /* synthetic */ Class access$000() {
        return DEFAULT_TARGET_FORMAT;
    }

    public static class Builder {
        @Nullable
        private ImageConfiguration baseImageConfiguration;
        @Nullable
        private ImageConfiguration targetImageConfiguration;
        private ImmutableSet<String> additionalTargetImageTags = ImmutableSet.of();
        @Nullable
        private ContainerConfiguration containerConfiguration;
        @Nullable
        private Path applicationLayersCacheDirectory;
        @Nullable
        private Path baseImageLayersCacheDirectory;
        private boolean allowInsecureRegistries = false;
        private boolean offline = false;
        private ImmutableList<LayerConfiguration> layerConfigurations = ImmutableList.of();
        private Class<? extends BuildableManifestTemplate> targetFormat = BuildConfiguration.access$000();
        private String toolName = "jib";
        private EventHandlers eventHandlers = EventHandlers.NONE;
        @Nullable
        private ExecutorService executorService;

        private Builder() {
        }

        public Builder setBaseImageConfiguration(ImageConfiguration imageConfiguration) {
            this.baseImageConfiguration = imageConfiguration;
            return this;
        }

        public Builder setTargetImageConfiguration(ImageConfiguration imageConfiguration) {
            this.targetImageConfiguration = imageConfiguration;
            return this;
        }

        public Builder setAdditionalTargetImageTags(Set<String> tags) {
            this.additionalTargetImageTags = ImmutableSet.copyOf(tags);
            return this;
        }

        public Builder setContainerConfiguration(ContainerConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return this;
        }

        public Builder setApplicationLayersCacheDirectory(Path applicationLayersCacheDirectory) {
            this.applicationLayersCacheDirectory = applicationLayersCacheDirectory;
            return this;
        }

        public Builder setBaseImageLayersCacheDirectory(Path baseImageLayersCacheDirectory) {
            this.baseImageLayersCacheDirectory = baseImageLayersCacheDirectory;
            return this;
        }

        public Builder setTargetFormat(ImageFormat targetFormat) {
            this.targetFormat = targetFormat == ImageFormat.Docker ? V22ManifestTemplate.class : OCIManifestTemplate.class;
            return this;
        }

        public Builder setAllowInsecureRegistries(boolean allowInsecureRegistries) {
            this.allowInsecureRegistries = allowInsecureRegistries;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setLayerConfigurations(List<LayerConfiguration> layerConfigurations) {
            this.layerConfigurations = ImmutableList.copyOf(layerConfigurations);
            return this;
        }

        public Builder setToolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public Builder setEventHandlers(EventHandlers eventHandlers) {
            this.eventHandlers = eventHandlers;
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BuildConfiguration build() throws IOException {
            ArrayList<String> missingFields = new ArrayList<String>();
            if (this.baseImageConfiguration == null) {
                missingFields.add("base image configuration");
            }
            if (this.targetImageConfiguration == null) {
                missingFields.add("target image configuration");
            }
            if (this.baseImageLayersCacheDirectory == null) {
                missingFields.add("base image layers cache directory");
            }
            if (this.applicationLayersCacheDirectory == null) {
                missingFields.add("application layers cache directory");
            }
            if (this.executorService == null) {
                missingFields.add("executor service");
            }
            switch (missingFields.size()) {
                case 0: {
                    if (((ImageConfiguration)Preconditions.checkNotNull((Object)this.baseImageConfiguration)).getImage().usesDefaultTag()) {
                        this.eventHandlers.dispatch(LogEvent.warn("Base image '" + this.baseImageConfiguration.getImage() + "' does not use a specific image digest - build may not be reproducible"));
                    }
                    return new BuildConfiguration(this.baseImageConfiguration, (ImageConfiguration)Preconditions.checkNotNull((Object)this.targetImageConfiguration), this.additionalTargetImageTags, this.containerConfiguration, Cache.withDirectory((Path)Preconditions.checkNotNull((Object)this.baseImageLayersCacheDirectory)), Cache.withDirectory((Path)Preconditions.checkNotNull((Object)this.applicationLayersCacheDirectory)), this.targetFormat, this.allowInsecureRegistries, this.offline, this.layerConfigurations, this.toolName, this.eventHandlers, (ExecutorService)Preconditions.checkNotNull((Object)this.executorService));
                }
                case 1: {
                    throw new IllegalStateException((String)missingFields.get(0) + " is required but not set");
                }
                case 2: {
                    throw new IllegalStateException((String)missingFields.get(0) + " and " + (String)missingFields.get(1) + " are required but not set");
                }
            }
            missingFields.add("and " + (String)missingFields.remove(missingFields.size() - 1));
            StringJoiner errorMessage = new StringJoiner(", ", "", " are required but not set");
            for (String missingField : missingFields) {
                errorMessage.add(missingField);
            }
            throw new IllegalStateException(errorMessage.toString());
        }

        @Nullable
        @VisibleForTesting
        Path getBaseImageLayersCacheDirectory() {
            return this.baseImageLayersCacheDirectory;
        }

        @Nullable
        @VisibleForTesting
        Path getApplicationLayersCacheDirectory() {
            return this.applicationLayersCacheDirectory;
        }
    }
}

