/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.PushBlobStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class PushContainerConfigurationStep
implements AsyncStep<AsyncStep<PushBlobStep>>,
Callable<AsyncStep<PushBlobStep>> {
    private static final String DESCRIPTION = "Pushing container configuration";
    private final BuildConfiguration buildConfiguration;
    private final ListeningExecutorService listeningExecutorService;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final AuthenticatePushStep authenticatePushStep;
    private final BuildImageStep buildImageStep;
    private final ListenableFuture<AsyncStep<PushBlobStep>> listenableFuture;

    PushContainerConfigurationStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, AuthenticatePushStep authenticatePushStep, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.authenticatePushStep = authenticatePushStep;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(buildImageStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<AsyncStep<PushBlobStep>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public AsyncStep<PushBlobStep> call() throws ExecutionException {
        ListenableFuture<PushBlobStep> pushBlobStepFuture = AsyncDependencies.using(this.listeningExecutorService).addStep(this.authenticatePushStep).addStep(NonBlockingSteps.get(this.buildImageStep)).whenAllSucceed(this::afterBuildConfigurationFutureFuture);
        return () -> pushBlobStepFuture;
    }

    private PushBlobStep afterBuildConfigurationFutureFuture() throws ExecutionException, IOException {
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = this.progressEventDispatcherFactory.create("pushing container configuration", 1L);){
            PushBlobStep pushBlobStep;
            TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventHandlers(), DESCRIPTION);
            Throwable throwable2 = null;
            try {
                Image image = NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep));
                JsonTemplate containerConfiguration = new ImageToJsonTranslator(image).getContainerConfiguration();
                BlobDescriptor blobDescriptor = Digests.computeDigest(containerConfiguration);
                pushBlobStep = new PushBlobStep(this.listeningExecutorService, this.buildConfiguration, progressEventDispatcher.newChildProducer(), this.authenticatePushStep, blobDescriptor, Blobs.from(containerConfiguration));
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        PushContainerConfigurationStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            PushContainerConfigurationStep.$closeResource(throwable2, ignored);
            return pushBlobStep;
        }
    }
}

