/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class PullAndCacheBaseImageLayersStep
implements AsyncStep<ImmutableList<PullAndCacheBaseImageLayerStep>>,
Callable<ImmutableList<PullAndCacheBaseImageLayerStep>> {
    private static final String DESCRIPTION = "Setting up base image caching";
    private final BuildConfiguration buildConfiguration;
    private final ListeningExecutorService listeningExecutorService;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final PullBaseImageStep pullBaseImageStep;
    private final ListenableFuture<ImmutableList<PullAndCacheBaseImageLayerStep>> listenableFuture;

    PullAndCacheBaseImageLayersStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, PullBaseImageStep pullBaseImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.pullBaseImageStep = pullBaseImageStep;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(pullBaseImageStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<ImmutableList<PullAndCacheBaseImageLayerStep>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public ImmutableList<PullAndCacheBaseImageLayerStep> call() throws ExecutionException, LayerPropertyNotFoundException {
        PullBaseImageStep.BaseImageWithAuthorization pullBaseImageStepResult = NonBlockingSteps.get(this.pullBaseImageStep);
        ImmutableList<Layer> baseImageLayers = pullBaseImageStepResult.getBaseImage().getLayers();
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = this.progressEventDispatcherFactory.create("checking base image layers", baseImageLayers.size());){
            UnmodifiableIterator unmodifiableIterator;
            TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventHandlers(), DESCRIPTION);
            Throwable throwable2 = null;
            try {
                ImmutableList.Builder pullAndCacheBaseImageLayerStepsBuilder = ImmutableList.builderWithExpectedSize((int)baseImageLayers.size());
                for (Layer layer : baseImageLayers) {
                    pullAndCacheBaseImageLayerStepsBuilder.add((Object)new PullAndCacheBaseImageLayerStep(this.listeningExecutorService, this.buildConfiguration, progressEventDispatcher.newChildProducer(), layer.getBlobDescriptor().getDigest(), pullBaseImageStepResult.getBaseImageAuthorization()));
                }
                unmodifiableIterator = pullAndCacheBaseImageLayerStepsBuilder.build();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        PullAndCacheBaseImageLayersStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            PullAndCacheBaseImageLayersStep.$closeResource(throwable2, ignored);
            return unmodifiableIterator;
        }
    }
}

