/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class FilePermissions {
    public static final FilePermissions DEFAULT_FILE_PERMISSIONS = new FilePermissions(420);
    public static final FilePermissions DEFAULT_FOLDER_PERMISSIONS = new FilePermissions(493);
    private static final String OCTAL_PATTERN = "[0-7][0-7][0-7]";
    private static final ImmutableMap<PosixFilePermission, Integer> PERMISSION_MAP = ImmutableMap.builder().put((Object)PosixFilePermission.OWNER_READ, (Object)256).put((Object)PosixFilePermission.OWNER_WRITE, (Object)128).put((Object)PosixFilePermission.OWNER_EXECUTE, (Object)64).put((Object)PosixFilePermission.GROUP_READ, (Object)32).put((Object)PosixFilePermission.GROUP_WRITE, (Object)16).put((Object)PosixFilePermission.GROUP_EXECUTE, (Object)8).put((Object)PosixFilePermission.OTHERS_READ, (Object)4).put((Object)PosixFilePermission.OTHERS_WRITE, (Object)2).put((Object)PosixFilePermission.OTHERS_EXECUTE, (Object)1).build();
    private final int permissionBits;

    public static FilePermissions fromOctalString(String octalPermissions) {
        Preconditions.checkArgument((boolean)octalPermissions.matches(OCTAL_PATTERN), (Object)"octalPermissions must be a 3-digit octal number (000-777)");
        return new FilePermissions(Integer.parseInt(octalPermissions, 8));
    }

    public static FilePermissions fromPosixFilePermissions(Set<PosixFilePermission> posixFilePermissions) {
        int permissionBits = 0;
        for (PosixFilePermission permission : posixFilePermissions) {
            permissionBits |= ((Integer)Preconditions.checkNotNull((Object)((Integer)PERMISSION_MAP.get((Object)permission)))).intValue();
        }
        return new FilePermissions(permissionBits);
    }

    @VisibleForTesting
    FilePermissions(int permissionBits) {
        this.permissionBits = permissionBits;
    }

    public int getPermissionBits() {
        return this.permissionBits;
    }

    public String toOctalString() {
        return Integer.toString(this.permissionBits, 8);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FilePermissions)) {
            return false;
        }
        FilePermissions otherFilePermissions = (FilePermissions)other;
        return this.permissionBits == otherFilePermissions.permissionBits;
    }

    public int hashCode() {
        return this.permissionBits;
    }
}

