/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ReproducibleLayerBuilder {
    private final List<LayerEntry> layerEntries = new ArrayList<LayerEntry>();

    public ReproducibleLayerBuilder addFiles(List<Path> sourceFiles, String extractionPath) {
        this.layerEntries.add(new LayerEntry(ImmutableList.copyOf(sourceFiles), extractionPath));
        return this;
    }

    public UnwrittenLayer build() throws IOException {
        ArrayList<TarArchiveEntry> filesystemEntries = new ArrayList<TarArchiveEntry>();
        for (LayerEntry layerEntry : this.layerEntries) {
            filesystemEntries.addAll(layerEntry.buildAsTarArchiveEntries());
        }
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        filesystemEntries.sort(Comparator.comparing(TarArchiveEntry::getName));
        for (TarArchiveEntry entry : filesystemEntries) {
            entry.setModTime(0L);
            entry.setGroupId(0);
            entry.setUserId(0);
            entry.setUserName("");
            entry.setGroupName("");
            tarStreamBuilder.addEntry(entry);
        }
        return new UnwrittenLayer(tarStreamBuilder.toBlob());
    }

    public List<Path> getSourceFiles() {
        ArrayList<Path> allSourceFiles = new ArrayList<Path>();
        for (LayerEntry layerEntry : this.layerEntries) {
            allSourceFiles.addAll((Collection<Path>)layerEntry.sourceFiles);
        }
        return allSourceFiles;
    }

    private static class LayerEntry {
        private final ImmutableList<Path> sourceFiles;
        private final String extractionPath;

        private LayerEntry(ImmutableList<Path> sourceFiles, String extractionPath) {
            this.sourceFiles = sourceFiles;
            this.extractionPath = extractionPath;
        }

        private List<TarArchiveEntry> buildAsTarArchiveEntries() throws IOException {
            ArrayList<TarArchiveEntry> tarArchiveEntries = new ArrayList<TarArchiveEntry>();
            for (Path sourceFile : this.sourceFiles) {
                if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                    new DirectoryWalker(sourceFile).filterRoot().walk(path -> {
                        StringBuilder subExtractionPath = new StringBuilder(this.extractionPath);
                        Path sourceFileRelativePath = sourceFile.getParent().relativize(path);
                        for (Path sourceFileRelativePathComponent : sourceFileRelativePath) {
                            subExtractionPath.append('/').append(sourceFileRelativePathComponent);
                        }
                        tarArchiveEntries.add(new TarArchiveEntry(path.toFile(), subExtractionPath.toString()));
                    });
                    continue;
                }
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(sourceFile.toFile(), this.extractionPath + "/" + sourceFile.getFileName());
                tarArchiveEntries.add(tarArchiveEntry);
            }
            return tarArchiveEntries;
        }
    }
}

