/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.frontend.MainClassInferenceException;
import com.google.cloud.tools.jib.frontend.ProjectProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.annotation.Nullable;

public class MainClassFinder {
    public static String resolveMainClass(@Nullable String mainClass, ProjectProperties projectProperties) throws MainClassInferenceException {
        BuildLogger logger = projectProperties.getLogger();
        if (mainClass == null) {
            logger.info("Searching for main class... Add a 'mainClass' configuration to '" + projectProperties.getPluginName() + "' to improve build speed.");
            mainClass = projectProperties.getMainClassFromJar();
            if (mainClass == null || !BuildConfiguration.isValidJavaClass(mainClass)) {
                logger.debug("Could not find a valid main class specified in " + projectProperties.getJarPluginName() + "; attempting to infer main class.");
                try {
                    HashSet<Path> visitedRoots = new HashSet<Path>();
                    ArrayList<String> mainClasses = new ArrayList<String>();
                    for (Path classPath : projectProperties.getSourceFilesConfiguration().getClassesFiles()) {
                        Path root = classPath.getParent();
                        if (visitedRoots.contains(root)) continue;
                        visitedRoots.add(root);
                        mainClasses.addAll(MainClassFinder.findMainClasses(root, logger));
                    }
                    if (mainClasses.size() == 1) {
                        mainClass = (String)mainClasses.get(0);
                    } else {
                        if (mainClasses.size() == 0 && mainClass == null) {
                            throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Main class was not found").forMainClassNotFound(projectProperties.getPluginName()));
                        }
                        if (mainClasses.size() > 1 && mainClass == null) {
                            throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Multiple valid main classes were found: " + String.join((CharSequence)", ", mainClasses)).forMainClassNotFound(projectProperties.getPluginName()));
                        }
                    }
                }
                catch (IOException ex) {
                    throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Failed to get main class").forMainClassNotFound(projectProperties.getPluginName()), ex);
                }
            }
        }
        Preconditions.checkNotNull((Object)mainClass);
        if (!BuildConfiguration.isValidJavaClass(mainClass)) {
            logger.warn("'mainClass' is not a valid Java class : " + mainClass);
        }
        return mainClass;
    }

    @VisibleForTesting
    static List<String> findMainClasses(Path rootDirectory, BuildLogger buildLogger) throws IOException {
        if (!Files.exists(rootDirectory, new LinkOption[0]) || !Files.isDirectory(rootDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>();
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        try {
            CtClass[] mainMethodParams = new CtClass[]{classPool.get("java.lang.String[]")};
            new DirectoryWalker(rootDirectory).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".class")).walk(classFile -> {
                try (InputStream classFileInputStream2 = Files.newInputStream(classFile, new OpenOption[0]);){
                    CtClass fileClass = classPool.makeClass(classFileInputStream2);
                    CtMethod mainMethod = fileClass.getDeclaredMethod("main", mainMethodParams);
                    if (CtClass.voidType.equals(mainMethod.getReturnType()) && Modifier.isStatic(mainMethod.getModifiers()) && Modifier.isPublic(mainMethod.getModifiers())) {
                        classNames.add(fileClass.getName());
                    }
                }
                catch (NotFoundException classFileInputStream2) {
                }
                catch (IOException ex) {
                    buildLogger.warn("Could not read class file: " + classFile);
                }
            });
            return classNames;
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private MainClassFinder() {
    }
}

