/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExposedPortsParser {
    private static final Pattern portPattern = Pattern.compile("(\\d+)(?:-(\\d+))?(/tcp|/udp)?");

    @VisibleForTesting
    public static ImmutableList<String> parse(List<String> ports, BuildLogger buildLogger) throws NumberFormatException {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (String port : ports) {
            int min;
            Matcher matcher = portPattern.matcher(port);
            if (!matcher.matches()) {
                throw new NumberFormatException("Invalid port configuration: '" + port + "'. Make sure the port is a single number or a range of two numbers separated with a '-', with or without protocol specified (e.g. '<portNum>/tcp' or '<portNum>/udp').");
            }
            int max = min = Integer.parseInt(matcher.group(1));
            if (!Strings.isNullOrEmpty((String)matcher.group(2))) {
                max = Integer.parseInt(matcher.group(2));
            }
            String protocol = matcher.group(3);
            if (min > max) {
                throw new NumberFormatException("Invalid port range '" + port + "'; smaller number must come first.");
            }
            if (min < 1 || max > 65535) {
                buildLogger.warn("Port number '" + port + "' is out of usual range (1-65535).");
            }
            String portString = protocol == null ? "" : protocol;
            for (int portNum = min; portNum <= max; ++portNum) {
                result.add((Object)(portNum + portString));
            }
        }
        return result.build();
    }

    private ExposedPortsParser() {
    }
}

