/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.common.base.Preconditions;

public class PortsWithProtocol {
    private final int minPort;
    private final int maxPort;
    private final Protocol protocol;

    public static PortsWithProtocol forRange(int minPort, int maxPort, Protocol protocol) {
        Preconditions.checkArgument((minPort <= maxPort ? 1 : 0) != 0, (Object)"minPort must be less than or equal to maxPort in port range");
        return new PortsWithProtocol(minPort, maxPort, protocol);
    }

    public static PortsWithProtocol forSingle(int port, Protocol protocol) {
        return new PortsWithProtocol(port, port, protocol);
    }

    public int getMinPort() {
        return this.minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    private PortsWithProtocol(int minPort, int maxPort, Protocol protocol) {
        this.minPort = minPort;
        this.maxPort = maxPort;
        this.protocol = protocol;
    }

    public static enum Protocol {
        TCP("tcp"),
        UDP("udp");

        private final String stringRepresentation;

        private Protocol(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }
    }
}

