/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class PullAndCacheBaseImageLayersStep
implements AsyncStep<ImmutableList<PullAndCacheBaseImageLayerStep>>,
Callable<ImmutableList<PullAndCacheBaseImageLayerStep>> {
    private static final String DESCRIPTION = "Setting up base image caching";
    private final BuildConfiguration buildConfiguration;
    private final Cache cache;
    private final PullBaseImageStep pullBaseImageStep;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<ImmutableList<PullAndCacheBaseImageLayerStep>> listenableFuture;

    PullAndCacheBaseImageLayersStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, Cache cache, PullBaseImageStep pullBaseImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.cache = cache;
        this.pullBaseImageStep = pullBaseImageStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullBaseImageStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<ImmutableList<PullAndCacheBaseImageLayerStep>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public ImmutableList<PullAndCacheBaseImageLayerStep> call() throws ExecutionException, LayerPropertyNotFoundException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            PullBaseImageStep.BaseImageWithAuthorization pullBaseImageStepResult = NonBlockingSteps.get(this.pullBaseImageStep);
            ImmutableList<Layer> baseImageLayers = pullBaseImageStepResult.getBaseImage().getLayers();
            ImmutableList.Builder pullAndCacheBaseImageLayerStepsBuilder = ImmutableList.builderWithExpectedSize((int)baseImageLayers.size());
            for (Layer layer : baseImageLayers) {
                pullAndCacheBaseImageLayerStepsBuilder.add((Object)new PullAndCacheBaseImageLayerStep(this.listeningExecutorService, this.buildConfiguration, this.cache, layer.getBlobDescriptor().getDigest(), pullBaseImageStepResult.getBaseImageAuthorization()));
            }
            UnmodifiableIterator unmodifiableIterator = pullAndCacheBaseImageLayerStepsBuilder.build();
            return unmodifiableIterator;
        }
    }
}

