/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.ncache.CacheCorruptedException;
import com.google.cloud.tools.jib.ncache.CacheEntry;
import com.google.cloud.tools.jib.ncache.CacheStorage;
import com.google.cloud.tools.jib.ncache.CacheWrite;
import com.google.cloud.tools.jib.ncache.DefaultCacheStorage;
import com.google.cloud.tools.jib.ncache.LastModifiedTimeMetadata;
import com.google.cloud.tools.jib.ncache.LayerEntriesSelector;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Cache {
    private final CacheStorage cacheStorage;

    public static Cache withDirectory(Path cacheDirectory) throws IOException {
        Files.createDirectories(cacheDirectory, new FileAttribute[0]);
        return new Cache(DefaultCacheStorage.withDirectory(cacheDirectory));
    }

    private Cache(CacheStorage cacheStorage) {
        this.cacheStorage = cacheStorage;
    }

    public CacheEntry write(Blob layerBlob) throws IOException {
        return this.cacheStorage.write(CacheWrite.layerOnly(layerBlob));
    }

    public CacheEntry write(Blob layerBlob, ImmutableList<LayerEntry> layerEntries) throws IOException {
        return this.cacheStorage.write(CacheWrite.withSelectorAndMetadata(layerBlob, LayerEntriesSelector.generateSelector(layerEntries), LastModifiedTimeMetadata.generateMetadata(layerEntries)));
    }

    public Optional<CacheEntry> retrieve(ImmutableList<LayerEntry> layerEntries) throws IOException, CacheCorruptedException {
        Optional<DescriptorDigest> optionalSelectedLayerDigest = this.cacheStorage.select(LayerEntriesSelector.generateSelector(layerEntries));
        if (!optionalSelectedLayerDigest.isPresent()) {
            return Optional.empty();
        }
        Optional<CacheEntry> optionalCacheEntry = this.cacheStorage.retrieve(optionalSelectedLayerDigest.get());
        if (!optionalCacheEntry.isPresent()) {
            return Optional.empty();
        }
        CacheEntry cacheEntry = optionalCacheEntry.get();
        Optional<FileTime> optionalRetrievedLastModifiedTime = LastModifiedTimeMetadata.getLastModifiedTime(cacheEntry);
        if (!optionalRetrievedLastModifiedTime.isPresent()) {
            return Optional.empty();
        }
        FileTime retrievedLastModifiedTime = optionalRetrievedLastModifiedTime.get();
        FileTime expectedLastModifiedTime = LastModifiedTimeMetadata.getLastModifiedTime(layerEntries);
        if (!expectedLastModifiedTime.equals(retrievedLastModifiedTime)) {
            return Optional.empty();
        }
        return Optional.of(cacheEntry);
    }

    public Optional<CacheEntry> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        return this.cacheStorage.retrieve(layerDigest);
    }
}

