/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;

@Mojo(name="_skaffold-files", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class FilesMojo
extends AbstractMojo {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-files";
    @Nullable
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Nullable
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Nullable
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Nullable
    @Parameter(defaultValue="${project.basedir}/src/main/jib", required=true)
    private File extraDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Preconditions.checkNotNull((Object)this.project);
        Preconditions.checkNotNull(this.projects);
        Preconditions.checkNotNull((Object)this.session);
        Preconditions.checkNotNull((Object)this.extraDirectory);
        Preconditions.checkNotNull((Object)this.projectDependenciesResolver);
        System.out.println(this.project.getFile());
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        System.out.println(this.project.getBuild().getSourceDirectory());
        ImmutableSet.copyOf((Collection)this.project.getBuild().getResources()).stream().map(FileSet::getDirectory).forEach(System.out::println);
        if (this.project.getPlugin("com.google.cloud.tools:jib-maven-plugin") != null) {
            System.out.println(this.extraDirectory.getAbsoluteFile().toPath());
        }
        Set projectArtifacts = this.projects.stream().map(MavenProject::getArtifact).map(Object::toString).collect(Collectors.toSet());
        DependencyFilter ignoreProjectDependenciesFilter = (node, parents) -> {
            if (node == null || node.getDependency() == null) {
                return false;
            }
            if (projectArtifacts.contains(node.getArtifact().toString())) {
                return false;
            }
            return "compile+runtime".contains(node.getDependency().getScope());
        };
        try {
            DependencyResolutionResult resolutionResult = this.projectDependenciesResolver.resolve(new DefaultDependencyResolutionRequest(this.project, this.session.getRepositorySession()).setResolutionFilter(ignoreProjectDependenciesFilter));
            resolutionResult.getDependencies().stream().map(Dependency::getArtifact).filter(Artifact::isSnapshot).map(Artifact::getFile).forEach(System.out::println);
        }
        catch (DependencyResolutionException ex) {
            throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)ex));
        }
    }
}

