/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import java.util.function.Function;
import javax.annotation.Nullable;

class MavenHelpfulSuggestionsBuilder {
    private static final Function<String, String> AUTH_CONFIGURATION_SUGGESTION = registry -> "set credentials for '" + registry + "' in your Maven settings";
    private final String messagePrefix;
    private final JibPluginConfiguration jibPluginConfiguration;
    @Nullable
    private ImageReference baseImageReference;
    @Nullable
    private ImageReference targetImageReference;
    private boolean baseImageHasConfiguredCredentials;
    private boolean targetImageHasConfiguredCredentials;

    MavenHelpfulSuggestionsBuilder(String messagePrefix, JibPluginConfiguration jibPluginConfiguration) {
        this.messagePrefix = messagePrefix;
        this.jibPluginConfiguration = jibPluginConfiguration;
    }

    MavenHelpfulSuggestionsBuilder setBaseImageReference(ImageReference baseImageReference) {
        this.baseImageReference = baseImageReference;
        return this;
    }

    MavenHelpfulSuggestionsBuilder setBaseImageHasConfiguredCredentials(boolean areKnownCredentialsDefined) {
        this.baseImageHasConfiguredCredentials = areKnownCredentialsDefined;
        return this;
    }

    MavenHelpfulSuggestionsBuilder setTargetImageReference(ImageReference targetImageReference) {
        this.targetImageReference = targetImageReference;
        return this;
    }

    MavenHelpfulSuggestionsBuilder setTargetImageHasConfiguredCredentials(boolean areKnownCredentialsDefined) {
        this.targetImageHasConfiguredCredentials = areKnownCredentialsDefined;
        return this;
    }

    HelpfulSuggestions build() {
        boolean isCredHelperDefinedForBaseImage = this.jibPluginConfiguration.getTargetImageCredentialHelperName() != null;
        boolean isCredHelperDefinedForTargetImage = this.jibPluginConfiguration.getTargetImageCredentialHelperName() != null;
        return new HelpfulSuggestions(this.messagePrefix, "mvn clean", this.baseImageReference, !isCredHelperDefinedForBaseImage && !this.baseImageHasConfiguredCredentials, "<from><credHelper>", AUTH_CONFIGURATION_SUGGESTION, this.targetImageReference, !isCredHelperDefinedForTargetImage && !this.targetImageHasConfiguredCredentials, "<to><credHelper>", AUTH_CONFIGURATION_SUGGESTION, "<to><image>", "-Dimage", "pom.xml");
    }
}

