/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import java.util.Objects;

public class Port {
    private static final String TCP_PROTOCOL = "tcp";
    private static final String UDP_PROTOCOL = "udp";
    private final int port;
    private final String protocol;

    public static Port tcp(int port) {
        return new Port(port, TCP_PROTOCOL);
    }

    public static Port udp(int port) {
        return new Port(port, UDP_PROTOCOL);
    }

    public static Port parseProtocol(int port, String protocolString) {
        String protocol = UDP_PROTOCOL.equalsIgnoreCase(protocolString) ? UDP_PROTOCOL : TCP_PROTOCOL;
        return new Port(port, protocol);
    }

    private Port(int port, String protocol) {
        this.port = port;
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Port)) {
            return false;
        }
        Port otherPort = (Port)other;
        return this.port == otherPort.port && this.protocol.equals(otherPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.protocol);
    }

    public String toString() {
        return this.port + "/" + this.protocol;
    }
}

