/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LayerConfiguration {
    private final ImmutableList<LayerEntry> layerEntries;
    private final String name;

    public static Builder builder() {
        return new Builder();
    }

    private LayerConfiguration(String name, ImmutableList<LayerEntry> layerEntries) {
        this.name = name;
        this.layerEntries = layerEntries;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<LayerEntry> getLayerEntries() {
        return this.layerEntries;
    }

    public static class Builder {
        private final ImmutableList.Builder<LayerEntry> layerEntries = ImmutableList.builder();
        private String name = "";

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addEntry(Path sourceFile, AbsoluteUnixPath pathInContainer) {
            this.layerEntries.add((Object)new LayerEntry(sourceFile, pathInContainer));
            return this;
        }

        public Builder addEntryRecursive(Path sourceFile, AbsoluteUnixPath pathInContainer) throws IOException {
            if (!Files.isDirectory(sourceFile, new LinkOption[0])) {
                return this.addEntry(sourceFile, pathInContainer);
            }
            this.addEntry(sourceFile, pathInContainer);
            try (Stream<Path> files = Files.list(sourceFile);){
                for (Path file : files.collect(Collectors.toList())) {
                    this.addEntryRecursive(file, pathInContainer.resolve(file.getFileName()));
                }
            }
            return this;
        }

        public LayerConfiguration build() {
            return new LayerConfiguration(this.name, this.layerEntries.build());
        }
    }
}

