/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.builder.TimerEventEmitter;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.configuration.credentials.CredentialRetriever;
import com.google.cloud.tools.jib.event.EventEmitter;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class RetrieveRegistryCredentialsStep
implements AsyncStep<Credential>,
Callable<Credential> {
    private final EventEmitter eventEmitter;
    private final String registry;
    private final ImmutableList<CredentialRetriever> credentialRetrievers;
    private final ListenableFuture<Credential> listenableFuture;

    private static String makeDescription(String registry) {
        return "Retrieving registry credentials for " + registry;
    }

    static RetrieveRegistryCredentialsStep forBaseImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getEventEmitter(), buildConfiguration.getBaseImageConfiguration().getImageRegistry(), buildConfiguration.getBaseImageConfiguration().getCredentialRetrievers());
    }

    static RetrieveRegistryCredentialsStep forTargetImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getEventEmitter(), buildConfiguration.getTargetImageConfiguration().getImageRegistry(), buildConfiguration.getTargetImageConfiguration().getCredentialRetrievers());
    }

    @VisibleForTesting
    RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, EventEmitter eventEmitter, String registry, ImmutableList<CredentialRetriever> credentialRetrievers) {
        this.eventEmitter = eventEmitter;
        this.registry = registry;
        this.credentialRetrievers = credentialRetrievers;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<Credential> getFuture() {
        return this.listenableFuture;
    }

    @Override
    @Nullable
    public Credential call() throws CredentialRetrievalException {
        String description = RetrieveRegistryCredentialsStep.makeDescription(this.registry);
        this.eventEmitter.emit(LogEvent.lifecycle(description + "..."));
        try (TimerEventEmitter ignored = new TimerEventEmitter(this.eventEmitter, description);){
            for (CredentialRetriever credentialRetriever : this.credentialRetrievers) {
                Optional<Credential> optionalCredential = credentialRetriever.retrieve();
                if (!optionalCredential.isPresent()) continue;
                Credential credential = optionalCredential.get();
                return credential;
            }
            this.eventEmitter.emit(LogEvent.info("No credentials could be retrieved for registry " + this.registry));
            UnmodifiableIterator unmodifiableIterator = null;
            return unmodifiableIterator;
        }
    }
}

