/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class BuildImageStep
implements AsyncStep<AsyncStep<Image<CachedLayer>>>,
Callable<AsyncStep<Image<CachedLayer>>> {
    private static final String DESCRIPTION = "Building container configuration";
    private final BuildConfiguration buildConfiguration;
    private final PullBaseImageStep pullBaseImageStep;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<AsyncStep<Image<CachedLayer>>> listenableFuture;

    BuildImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, PullBaseImageStep pullBaseImageStep, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.pullBaseImageStep = pullBaseImageStep;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = buildAndCacheApplicationLayerSteps;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullBaseImageStep.getFuture(), pullAndCacheBaseImageLayersStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<AsyncStep<Image<CachedLayer>>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public AsyncStep<Image<CachedLayer>> call() throws ExecutionException {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        for (PullAndCacheBaseImageLayerStep pullAndCacheBaseImageLayerStep : NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)) {
            dependencies.add(pullAndCacheBaseImageLayerStep.getFuture());
        }
        for (BuildAndCacheApplicationLayerStep buildAndCacheApplicationLayerStep : this.buildAndCacheApplicationLayerSteps) {
            dependencies.add(buildAndCacheApplicationLayerStep.getFuture());
        }
        ListenableFuture future = Futures.whenAllSucceed(dependencies).call(this::afterCachedLayersSteps, (Executor)this.listeningExecutorService);
        return () -> future;
    }

    private Image<CachedLayer> afterCachedLayersSteps() throws ExecutionException, LayerPropertyNotFoundException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            Image.Builder<CachedLayer> imageBuilder = Image.builder();
            Image<Layer> baseImage = NonBlockingSteps.get(this.pullBaseImageStep).getBaseImage();
            ContainerConfiguration containerConfiguration = this.buildConfiguration.getContainerConfiguration();
            List baseImageLayers = (List)NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep);
            for (PullAndCacheBaseImageLayerStep pullAndCacheBaseImageLayerStep : baseImageLayers) {
                imageBuilder.addLayer(NonBlockingSteps.get(pullAndCacheBaseImageLayerStep));
            }
            int nonEmptyLayerCount = 0;
            for (HistoryEntry historyObject : baseImage.getHistory()) {
                imageBuilder.addHistory(historyObject);
                if (historyObject.hasCorrespondingLayer()) continue;
                ++nonEmptyLayerCount;
            }
            imageBuilder.addEnvironment((Map<String, String>)baseImage.getEnvironment());
            imageBuilder.addLabels((Map<String, String>)baseImage.getLabels());
            imageBuilder.setWorkingDirectory(baseImage.getWorkingDirectory());
            Instant layerCreationTime = containerConfiguration == null ? ContainerConfiguration.DEFAULT_CREATION_TIME : containerConfiguration.getCreationTime();
            for (int count = 0; count < baseImageLayers.size() - nonEmptyLayerCount; ++count) {
                imageBuilder.addHistory(HistoryEntry.builder().setCreationTimestamp(layerCreationTime).setComment("auto-generated by Jib").build());
            }
            for (BuildAndCacheApplicationLayerStep buildAndCacheApplicationLayerStep : this.buildAndCacheApplicationLayerSteps) {
                imageBuilder.addLayer(NonBlockingSteps.get(buildAndCacheApplicationLayerStep));
                imageBuilder.addHistory(HistoryEntry.builder().setCreationTimestamp(layerCreationTime).setAuthor("Jib").setCreatedBy(this.buildConfiguration.getToolName()).build());
            }
            if (containerConfiguration != null) {
                imageBuilder.addEnvironment((Map<String, String>)containerConfiguration.getEnvironmentMap());
                imageBuilder.setCreated(containerConfiguration.getCreationTime());
                imageBuilder.setEntrypoint((List<String>)containerConfiguration.getEntrypoint());
                imageBuilder.setJavaArguments((List<String>)containerConfiguration.getProgramArguments());
                imageBuilder.setExposedPorts((List<Port>)containerConfiguration.getExposedPorts());
                imageBuilder.addLabels((Map<String, String>)containerConfiguration.getLabels());
            }
            Object object = imageBuilder.build();
            return object;
        }
    }
}

