/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.Timer;
import com.google.cloud.tools.jib.event.EventEmitter;
import com.google.cloud.tools.jib.event.events.TimerEvent;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.time.Clock;
import java.time.Duration;
import javax.annotation.Nullable;

public class TimerEventEmitter
implements Closeable {
    private static final Clock DEFAULT_CLOCK = Clock.systemUTC();
    private final EventEmitter eventEmitter;
    private final String description;
    private final Clock clock;
    private final Timer timer;

    public TimerEventEmitter(EventEmitter eventEmitter, String description) {
        this(eventEmitter, description, DEFAULT_CLOCK, null);
    }

    @VisibleForTesting
    TimerEventEmitter(EventEmitter eventEmitter, String description, Clock clock, @Nullable Timer parentTimer) {
        this.eventEmitter = eventEmitter;
        this.description = description;
        this.clock = clock;
        this.timer = new Timer(clock, parentTimer);
        this.emitTimerEvent(TimerEvent.State.START, Duration.ZERO);
    }

    public TimerEventEmitter subTimer(String description) {
        return new TimerEventEmitter(this.eventEmitter, description, this.clock, this.timer);
    }

    public void lap() {
        this.emitTimerEvent(TimerEvent.State.LAP, this.timer.lap());
    }

    @Override
    public void close() {
        this.emitTimerEvent(TimerEvent.State.FINISHED, this.timer.lap());
    }

    private void emitTimerEvent(TimerEvent.State state, Duration duration) {
        this.eventEmitter.emit(new TimerEvent(state, this.timer, duration, this.timer.getElapsedTime(), this.description));
    }
}

