/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import java.text.MessageFormat;

public class RegistryAuthenticationFailedException
extends Exception {
    private static final String REASON = "Failed to authenticate with registry {0}/{1} because: {2}";
    private final String serverUrl;
    private final String imageName;

    RegistryAuthenticationFailedException(String serverUrl, String imageName, Throwable cause) {
        super(MessageFormat.format(REASON, serverUrl, imageName, cause.getMessage()), cause);
        this.serverUrl = serverUrl;
        this.imageName = imageName;
    }

    RegistryAuthenticationFailedException(String serverUrl, String imageName, String reason) {
        super(MessageFormat.format(REASON, serverUrl, imageName, reason));
        this.serverUrl = serverUrl;
        this.imageName = imageName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getImageName() {
        return this.imageName;
    }
}

