/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.builder.BuildSteps;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import org.apache.http.conn.HttpHostConnectException;

public class BuildStepsRunner {
    private static final String STARTUP_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY = "Containerizing application to ";
    private static final String SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY = "Built and pushed image as ";
    private static final String STARTUP_MESSAGE_PREFIX_FOR_DOCKER_DAEMON = "Containerizing application to Docker daemon as ";
    private static final String SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_DAEMON = "Built image to Docker daemon as ";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_TARBALL = "Containerizing application to file at '%s'...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_TARBALL = "Built image tarball at \u001b[36m%s\u001b[0m";
    private final BuildSteps buildSteps;
    private final String startupMessage;
    private final String successMessage;

    private static CharSequence colorCyan(CharSequence innerText) {
        return new StringBuilder().append("\u001b[36m").append(innerText).append("\u001b[0m");
    }

    private static String buildMessageWithTargetImageReferences(BuildConfiguration buildConfiguration, String prefix, String suffix) {
        String targetRegistry = buildConfiguration.getTargetImageConfiguration().getImageRegistry();
        String targetRepository = buildConfiguration.getTargetImageConfiguration().getImageRepository();
        StringJoiner successMessageBuilder = new StringJoiner(", ", prefix, suffix);
        for (String tag : buildConfiguration.getAllTargetImageTags()) {
            successMessageBuilder.add(BuildStepsRunner.colorCyan(ImageReference.of(targetRegistry, targetRepository, tag).toString()));
        }
        return successMessageBuilder.toString();
    }

    public static BuildStepsRunner forBuildImage(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerRegistry(buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)), BuildStepsRunner.buildMessageWithTargetImageReferences(buildConfiguration, STARTUP_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY, "..."), BuildStepsRunner.buildMessageWithTargetImageReferences(buildConfiguration, SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_REGISTRY, ""));
    }

    public static BuildStepsRunner forBuildToDockerDaemon(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerDaemon(buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)), BuildStepsRunner.buildMessageWithTargetImageReferences(buildConfiguration, STARTUP_MESSAGE_PREFIX_FOR_DOCKER_DAEMON, "..."), BuildStepsRunner.buildMessageWithTargetImageReferences(buildConfiguration, SUCCESS_MESSAGE_PREFIX_FOR_DOCKER_DAEMON, ""));
    }

    public static BuildStepsRunner forBuildTar(Path outputPath, BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToTar(outputPath, buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)), String.format(STARTUP_MESSAGE_FORMAT_FOR_TARBALL, outputPath.toString()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_TARBALL, outputPath.toString()));
    }

    private static Caches.Initializer getCacheInitializer(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        CacheConfiguration applicationLayersCacheConfiguration = buildConfiguration.getApplicationLayersCacheConfiguration() == null ? CacheConfiguration.makeTemporary() : buildConfiguration.getApplicationLayersCacheConfiguration();
        CacheConfiguration baseImageLayersCacheConfiguration = buildConfiguration.getBaseImageLayersCacheConfiguration() == null ? CacheConfiguration.forDefaultUserLevelCacheDirectory() : buildConfiguration.getBaseImageLayersCacheConfiguration();
        return new Caches.Initializer(baseImageLayersCacheConfiguration.getCacheDirectory(), applicationLayersCacheConfiguration.shouldEnsureOwnership(), applicationLayersCacheConfiguration.getCacheDirectory(), applicationLayersCacheConfiguration.shouldEnsureOwnership());
    }

    private static void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpStatusCodeForbidden(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
        }
        throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialsDefined(registryUnauthorizedException.getRegistry(), registryUnauthorizedException.getRepository()), registryUnauthorizedException);
    }

    private static String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    @VisibleForTesting
    BuildStepsRunner(BuildSteps buildSteps, String startupMessage, String successMessage) {
        this.buildSteps = buildSteps;
        this.startupMessage = startupMessage;
        this.successMessage = successMessage;
    }

    public void build(HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        try {
            JibLogger buildLogger = this.buildSteps.getBuildConfiguration().getBuildLogger();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.startupMessage);
            buildLogger.info("Containerizing application with the following files:");
            for (LayerConfiguration layerConfiguration : this.buildSteps.getBuildConfiguration().getLayerConfigurations()) {
                if (layerConfiguration.getLayerEntries().isEmpty()) continue;
                buildLogger.info("\t" + BuildStepsRunner.capitalizeFirstLetter(layerConfiguration.getName()) + ":");
                for (LayerEntry layerEntry : layerConfiguration.getLayerEntries()) {
                    buildLogger.info("\t\t" + layerEntry.getSourceFile());
                }
            }
            this.buildSteps.run();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.successMessage);
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forCacheNeedsClean(), cacheMetadataCorruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable exceptionDuringBuildSteps = executionException.getCause();
            if (exceptionDuringBuildSteps instanceof HttpHostConnectException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forHttpHostConnect(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryUnauthorizedException) {
                BuildStepsRunner.handleRegistryUnauthorizedException((RegistryUnauthorizedException)exceptionDuringBuildSteps, helpfulSuggestions);
            }
            if (exceptionDuringBuildSteps instanceof RegistryCredentialsNotSentException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotSent(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryAuthenticationFailedException && exceptionDuringBuildSteps.getCause() instanceof HttpResponseException) {
                RegistryAuthenticationFailedException failureException = (RegistryAuthenticationFailedException)exceptionDuringBuildSteps;
                BuildStepsRunner.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(failureException.getServerUrl(), failureException.getImageName(), (HttpResponseException)exceptionDuringBuildSteps.getCause()), helpfulSuggestions);
            }
            if (exceptionDuringBuildSteps instanceof UnknownHostException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forUnknownHost(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof InsecureRegistryException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forInsecureRegistry(), exceptionDuringBuildSteps);
            }
            if (exceptionDuringBuildSteps instanceof RegistryErrorException) {
                RegistryErrorException registryErrorException = (RegistryErrorException)exceptionDuringBuildSteps;
                String message = (String)Verify.verifyNotNull((Object)registryErrorException.getMessage());
                throw new BuildStepsExecutionException(message, exceptionDuringBuildSteps);
            }
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), executionException.getCause());
        }
        catch (CacheDirectoryCreationException | IOException | InterruptedException ex) {
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), ex);
        }
        catch (CacheDirectoryNotOwnedException ex) {
            String helpfulSuggestion = helpfulSuggestions.forCacheDirectoryNotOwned(ex.getCacheDirectory());
            CacheConfiguration applicationLayersCacheConfiguration = this.buildSteps.getBuildConfiguration().getApplicationLayersCacheConfiguration();
            if (applicationLayersCacheConfiguration != null && ex.getCacheDirectory().equals(applicationLayersCacheConfiguration.getCacheDirectory())) {
                helpfulSuggestion = helpfulSuggestions.forCacheNeedsClean();
            }
            throw new BuildStepsExecutionException(helpfulSuggestion, ex);
        }
    }
}

