/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.ncache.CacheCorruptedException;
import com.google.cloud.tools.jib.ncache.CacheEntry;
import com.google.cloud.tools.jib.ncache.DefaultCacheEntry;
import com.google.cloud.tools.jib.ncache.DefaultCacheStorageFiles;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class DefaultCacheStorageReader {
    private final DefaultCacheStorageFiles defaultCacheStorageFiles;

    DefaultCacheStorageReader(DefaultCacheStorageFiles defaultCacheStorageFiles) {
        this.defaultCacheStorageFiles = defaultCacheStorageFiles;
    }

    Set<DescriptorDigest> fetchDigests() throws IOException, CacheCorruptedException {
        try (Stream<Path> layerDirectories = Files.list(this.defaultCacheStorageFiles.getLayersDirectory());){
            List layerDirectoriesList = layerDirectories.collect(Collectors.toList());
            HashSet<DescriptorDigest> layerDigests = new HashSet<DescriptorDigest>(layerDirectoriesList.size());
            for (Path layerDirectory : layerDirectoriesList) {
                try {
                    layerDigests.add(DescriptorDigest.fromHash(layerDirectory.getFileName().toString()));
                }
                catch (DigestException ex) {
                    throw new CacheCorruptedException("Found non-digest file in layers directory", ex);
                }
            }
            HashSet<DescriptorDigest> hashSet = layerDigests;
            return hashSet;
        }
    }

    Optional<CacheEntry> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        Path layerDirectory = this.defaultCacheStorageFiles.getLayerDirectory(layerDigest);
        if (!Files.exists(layerDirectory, new LinkOption[0])) {
            return Optional.empty();
        }
        DefaultCacheEntry.Builder cacheEntryBuilder = DefaultCacheEntry.builder().setLayerDigest(layerDigest);
        try (Stream<Path> filesInLayerDirectory = Files.list(layerDirectory);){
            for (Path fileInLayerDirectory : filesInLayerDirectory.collect(Collectors.toList())) {
                if (DefaultCacheStorageFiles.isLayerFile(fileInLayerDirectory)) {
                    if (cacheEntryBuilder.hasLayerBlob()) {
                        throw new CacheCorruptedException("Multiple layer files found for layer with digest " + layerDigest.getHash() + " in directory: " + layerDirectory);
                    }
                    cacheEntryBuilder.setLayerBlob(Blobs.from(fileInLayerDirectory)).setLayerDiffId(DefaultCacheStorageFiles.getDiffId(fileInLayerDirectory)).setLayerSize(Files.size(fileInLayerDirectory));
                    continue;
                }
                if (!DefaultCacheStorageFiles.isMetadataFile(fileInLayerDirectory)) continue;
                if (cacheEntryBuilder.hasMetadataBlob()) {
                    throw new CacheCorruptedException("Multiple metadata files found for layer with digest " + layerDigest.getHash() + " in directory: " + layerDirectory);
                }
                cacheEntryBuilder.setMetadataBlob(Blobs.from(fileInLayerDirectory));
            }
        }
        return Optional.of(cacheEntryBuilder.build());
    }

    Optional<DescriptorDigest> select(DescriptorDigest selector) throws CacheCorruptedException, IOException {
        Path selectorFile = this.defaultCacheStorageFiles.getSelectorFile(selector);
        if (!Files.exists(selectorFile, new LinkOption[0])) {
            return Optional.empty();
        }
        String selectorFileContents = new String(Files.readAllBytes(selectorFile), StandardCharsets.UTF_8);
        try {
            return Optional.of(DescriptorDigest.fromHash(selectorFileContents));
        }
        catch (DigestException ex) {
            throw new CacheCorruptedException("Expected valid layer digest as contents of selector file `" + selectorFile + "` for selector `" + selector.getHash() + "`, but got: " + selectorFileContents);
        }
    }
}

