/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.ncache.CacheEntry;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;

class DefaultCacheEntry
implements CacheEntry {
    private final DescriptorDigest layerDigest;
    private final DescriptorDigest layerDiffId;
    private final long layerSize;
    private final Blob layerBlob;
    @Nullable
    private final Blob metadataBlob;

    static Builder builder() {
        return new Builder();
    }

    private DefaultCacheEntry(DescriptorDigest layerDigest, DescriptorDigest layerDiffId, long layerSize, Blob layerBlob, @Nullable Blob metadataBlob) {
        this.layerDigest = layerDigest;
        this.layerDiffId = layerDiffId;
        this.layerSize = layerSize;
        this.layerBlob = layerBlob;
        this.metadataBlob = metadataBlob;
    }

    @Override
    public DescriptorDigest getLayerDigest() {
        return this.layerDigest;
    }

    @Override
    public DescriptorDigest getLayerDiffId() {
        return this.layerDiffId;
    }

    @Override
    public long getLayerSize() {
        return this.layerSize;
    }

    @Override
    public Blob getLayerBlob() {
        return this.layerBlob;
    }

    @Override
    public Optional<Blob> getMetadataBlob() {
        return Optional.ofNullable(this.metadataBlob);
    }

    static class Builder {
        @Nullable
        private DescriptorDigest layerDigest;
        @Nullable
        private DescriptorDigest layerDiffId;
        private long layerSize = -1L;
        @Nullable
        private Blob layerBlob;
        @Nullable
        private Blob metadataBlob;

        private Builder() {
        }

        Builder setLayerDigest(DescriptorDigest layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        Builder setLayerDiffId(DescriptorDigest layerDiffId) {
            this.layerDiffId = layerDiffId;
            return this;
        }

        Builder setLayerSize(long layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        Builder setLayerBlob(Blob layerBlob) {
            this.layerBlob = layerBlob;
            return this;
        }

        Builder setMetadataBlob(@Nullable Blob metadataBlob) {
            this.metadataBlob = metadataBlob;
            return this;
        }

        boolean hasLayerBlob() {
            return this.layerBlob != null;
        }

        boolean hasMetadataBlob() {
            return this.metadataBlob != null;
        }

        CacheEntry build() {
            return new DefaultCacheEntry((DescriptorDigest)Preconditions.checkNotNull((Object)this.layerDigest, (Object)"layerDigest required"), (DescriptorDigest)Preconditions.checkNotNull((Object)this.layerDiffId, (Object)"layerDiffId required"), this.layerSize, (Blob)Preconditions.checkNotNull((Object)this.layerBlob, (Object)"layerBlob required"), this.metadataBlob);
        }
    }
}

