/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class JavaLayerConfigurations {
    public static final String DEFAULT_APP_ROOT = "/app";
    private final ImmutableMap<LayerType, LayerConfiguration> layerConfigurationMap;
    private final ImmutableMap<LayerType, AbsoluteUnixPath> extractionPathMap;

    public static Builder builder() {
        return new Builder();
    }

    private JavaLayerConfigurations(ImmutableMap<LayerType, LayerConfiguration> layerConfigurationMap, ImmutableMap<LayerType, AbsoluteUnixPath> extractionPathMap) {
        this.layerConfigurationMap = layerConfigurationMap;
        this.extractionPathMap = extractionPathMap;
    }

    public ImmutableList<LayerConfiguration> getLayerConfigurations() {
        return this.layerConfigurationMap.values().asList();
    }

    public ImmutableList<LayerEntry> getDependencyLayerEntries() {
        return this.getLayerEntries(LayerType.DEPENDENCIES);
    }

    public ImmutableList<LayerEntry> getSnapshotDependencyLayerEntries() {
        return this.getLayerEntries(LayerType.SNAPSHOT_DEPENDENCIES);
    }

    public ImmutableList<LayerEntry> getResourceLayerEntries() {
        return this.getLayerEntries(LayerType.RESOURCES);
    }

    public ImmutableList<LayerEntry> getClassLayerEntries() {
        return this.getLayerEntries(LayerType.CLASSES);
    }

    public ImmutableList<LayerEntry> getExtraFilesLayerEntries() {
        return this.getLayerEntries(LayerType.EXTRA_FILES);
    }

    public ImmutableList<LayerEntry> getExplodedWarEntries() {
        return this.getLayerEntries(LayerType.EXPLODED_WAR);
    }

    public AbsoluteUnixPath getDependencyExtractionPath() {
        return this.getExtractionPath(LayerType.DEPENDENCIES);
    }

    public AbsoluteUnixPath getSnapshotDependencyExtractionPath() {
        return this.getExtractionPath(LayerType.SNAPSHOT_DEPENDENCIES);
    }

    public AbsoluteUnixPath getResourceExtractionPath() {
        return this.getExtractionPath(LayerType.RESOURCES);
    }

    public AbsoluteUnixPath getClassExtractionPath() {
        return this.getExtractionPath(LayerType.CLASSES);
    }

    public AbsoluteUnixPath getExtraFilesExtractionPath() {
        return this.getExtractionPath(LayerType.EXTRA_FILES);
    }

    public AbsoluteUnixPath getExplodedWarExtractionPath() {
        return this.getExtractionPath(LayerType.EXPLODED_WAR);
    }

    private ImmutableList<LayerEntry> getLayerEntries(LayerType layerType) {
        return ((LayerConfiguration)Preconditions.checkNotNull((Object)((LayerConfiguration)this.layerConfigurationMap.get((Object)layerType)))).getLayerEntries();
    }

    private AbsoluteUnixPath getExtractionPath(LayerType layerType) {
        return (AbsoluteUnixPath)Preconditions.checkNotNull((Object)((AbsoluteUnixPath)this.extractionPathMap.get((Object)layerType)));
    }

    public static class Builder {
        private final Map<LayerType, List<Path>> layerFilesMap = new EnumMap<LayerType, List<Path>>(LayerType.class);
        private final Map<LayerType, AbsoluteUnixPath> extractionPathMap = new EnumMap<LayerType, AbsoluteUnixPath>(LayerType.class);

        private Builder() {
            for (LayerType layerType : LayerType.values()) {
                this.layerFilesMap.put(layerType, new ArrayList());
                this.extractionPathMap.put(layerType, AbsoluteUnixPath.get("/"));
            }
        }

        public Builder setDependencyFiles(List<Path> dependencyFiles, AbsoluteUnixPath extractionPath) {
            this.layerFilesMap.put(LayerType.DEPENDENCIES, dependencyFiles);
            this.extractionPathMap.put(LayerType.DEPENDENCIES, extractionPath);
            return this;
        }

        public Builder setSnapshotDependencyFiles(List<Path> snapshotDependencyFiles, AbsoluteUnixPath extractionPath) {
            this.layerFilesMap.put(LayerType.SNAPSHOT_DEPENDENCIES, snapshotDependencyFiles);
            this.extractionPathMap.put(LayerType.SNAPSHOT_DEPENDENCIES, extractionPath);
            return this;
        }

        public Builder setResourceFiles(List<Path> resourceFiles, AbsoluteUnixPath extractionPath) {
            this.layerFilesMap.put(LayerType.RESOURCES, resourceFiles);
            this.extractionPathMap.put(LayerType.RESOURCES, extractionPath);
            return this;
        }

        public Builder setClassFiles(List<Path> classFiles, AbsoluteUnixPath extractionPath) {
            this.layerFilesMap.put(LayerType.CLASSES, classFiles);
            this.extractionPathMap.put(LayerType.CLASSES, extractionPath);
            return this;
        }

        public Builder setExtraFiles(List<Path> extraFiles, AbsoluteUnixPath extractionPath) {
            this.layerFilesMap.put(LayerType.EXTRA_FILES, extraFiles);
            this.extractionPathMap.put(LayerType.EXTRA_FILES, extractionPath);
            return this;
        }

        public Builder setExplodedWarFiles(List<Path> explodedWarFiles, AbsoluteUnixPath extractionPath) {
            this.layerFilesMap.put(LayerType.EXPLODED_WAR, explodedWarFiles);
            this.extractionPathMap.put(LayerType.EXPLODED_WAR, extractionPath);
            return this;
        }

        public JavaLayerConfigurations build() throws IOException {
            ImmutableMap.Builder layerConfigurationsMap = ImmutableMap.builderWithExpectedSize((int)LayerType.values().length);
            for (LayerType layerType : LayerType.values()) {
                AbsoluteUnixPath extractionPath = (AbsoluteUnixPath)Preconditions.checkNotNull((Object)this.extractionPathMap.get((Object)layerType));
                LayerConfiguration.Builder layerConfigurationBuilder = LayerConfiguration.builder().setName(layerType.getName());
                List layerFiles = (List)Preconditions.checkNotNull(this.layerFilesMap.get((Object)layerType));
                for (Path layerFile : layerFiles) {
                    layerConfigurationBuilder.addEntryRecursive(layerFile, extractionPath.resolve(layerFile.getFileName()));
                }
                layerConfigurationsMap.put((Object)layerType, (Object)layerConfigurationBuilder.build());
            }
            return new JavaLayerConfigurations(layerConfigurationsMap.build(), ImmutableMap.copyOf(this.extractionPathMap));
        }
    }

    @VisibleForTesting
    static enum LayerType {
        DEPENDENCIES("dependencies"),
        SNAPSHOT_DEPENDENCIES("snapshot dependencies"),
        RESOURCES("resources"),
        CLASSES("classes"),
        EXPLODED_WAR("exploded war"),
        EXTRA_FILES("extra files");

        private final String name;

        private LayerType(String name) {
            this.name = name;
        }

        @VisibleForTesting
        String getName() {
            return this.name;
        }
    }
}

