/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event;

import com.google.cloud.tools.jib.event.JibEvent;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;

class Handler<E extends JibEvent> {
    private final Class<E> eventClass;
    private final Consumer<E> eventConsumer;

    Handler(Class<E> eventClass, Consumer<E> eventConsumer) {
        this.eventClass = eventClass;
        this.eventConsumer = eventConsumer;
    }

    void handle(JibEvent jibEvent) {
        Preconditions.checkArgument((boolean)this.eventClass.isInstance(jibEvent));
        this.eventConsumer.accept((JibEvent)this.eventClass.cast(jibEvent));
    }
}

